@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.GetAssetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assetName Asset name parameter.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAssetPlainArgs(
    public val assetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.GetAssetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.inputs.GetAssetPlainArgs =
        com.pulumi.azurenative.deviceregistry.inputs.GetAssetPlainArgs.builder()
            .assetName(assetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssetPlainArgs].
 */
@PulumiTagMarker
public class GetAssetPlainArgsBuilder internal constructor() {
    private var assetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Asset name parameter.
     */
    @JvmName("myxgixnjxxlprjus")
    public suspend fun assetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assetName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fsniwmnesmfswrlg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAssetPlainArgs = GetAssetPlainArgs(
        assetName = assetName ?: throw PulumiNullFieldException("assetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
