@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the client authentication mechanism to the server.
 * @property mode Defines the mode to authenticate the user of the client at the server.
 * @property usernamePasswordCredentials Defines the username and password references when UsernamePassword user authentication mode is selected.
 * @property x509Credentials Defines the certificate reference when Certificate user authentication mode is selected.
 */
public data class AssetEndpointProfilePropertiesResponseUserAuthentication(
    public val mode: String,
    public val usernamePasswordCredentials:
    AssetEndpointProfilePropertiesResponseUsernamePasswordCredentials? = null,
    public val x509Credentials: AssetEndpointProfilePropertiesResponseX509Credentials? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.AssetEndpointProfilePropertiesResponseUserAuthentication):
            AssetEndpointProfilePropertiesResponseUserAuthentication =
            AssetEndpointProfilePropertiesResponseUserAuthentication(
                mode = javaType.mode(),
                usernamePasswordCredentials = javaType.usernamePasswordCredentials().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetEndpointProfilePropertiesResponseUsernamePasswordCredentials.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                x509Credentials = javaType.x509Credentials().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetEndpointProfilePropertiesResponseX509Credentials.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
