@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the certificate reference when Certificate user authentication mode is selected.
 * @property certificateReference A reference to secret containing the certificate and private key (e.g. stored as .der/.pem or .der/.pfx).
 */
public data class AssetEndpointProfilePropertiesResponseX509Credentials(
    public val certificateReference: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.AssetEndpointProfilePropertiesResponseX509Credentials):
            AssetEndpointProfilePropertiesResponseX509Credentials =
            AssetEndpointProfilePropertiesResponseX509Credentials(
                certificateReference = javaType.certificateReference(),
            )
    }
}
