@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property code Error code for classification of errors (ex: 400, 404, 500, etc.).
 * @property message Human readable helpful error message to provide additional context for error (ex: “capability Id 'foo' does not exist”).
 */
public data class AssetPropertiesResponseErrors(
    public val code: Int? = null,
    public val message: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.AssetPropertiesResponseErrors):
            AssetPropertiesResponseErrors = AssetPropertiesResponseErrors(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
