@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.azurenative.devices.CertificateArgs.builder
import com.pulumi.azurenative.devices.kotlin.inputs.CertificatePropertiesArgs
import com.pulumi.azurenative.devices.kotlin.inputs.CertificatePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The X509 Certificate.
 * Azure REST API version: 2022-04-30-preview. Prior API version in Azure Native 1.x: 2020-08-31.
 * Other available API versions: 2020-04-01, 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
 * ## Example Usage
 * ### Certificates_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificate = new AzureNative.Devices.Certificate("certificate", new()
 *     {
 *         CertificateName = "cert",
 *         Properties = new AzureNative.Devices.Inputs.CertificatePropertiesArgs
 *         {
 *             Certificate = "############################################",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "iothub",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devices.NewCertificate(ctx, "certificate", &devices.CertificateArgs{
 * 			CertificateName: pulumi.String("cert"),
 * 			Properties: &devices.CertificatePropertiesArgs{
 * 				Certificate: pulumi.String("############################################"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("iothub"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devices.Certificate;
 * import com.pulumi.azurenative.devices.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificate = new Certificate("certificate", CertificateArgs.builder()
 *             .certificateName("cert")
 *             .properties(Map.of("certificate", "############################################"))
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("iothub")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devices:Certificate cert /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}
 * ```
 * @property certificateName The name of the certificate
 * @property properties The description of an X509 CA Certificate.
 * @property resourceGroupName The name of the resource group that contains the IoT hub.
 * @property resourceName The name of the IoT hub.
 */
public data class CertificateArgs(
    public val certificateName: Output<String>? = null,
    public val properties: Output<CertificatePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.CertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.CertificateArgs =
        com.pulumi.azurenative.devices.CertificateArgs.builder()
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var properties: Output<CertificatePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value The name of the certificate
     */
    @JvmName("cqkrwwxdmuxmivpk")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value The description of an X509 CA Certificate.
     */
    @JvmName("joikcqiopxjxcyqk")
    public suspend fun properties(`value`: Output<CertificatePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the IoT hub.
     */
    @JvmName("xwdprwvagydpxsmf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the IoT hub.
     */
    @JvmName("kfttyeaxjscnyglx")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The name of the certificate
     */
    @JvmName("awxsurobmqrsjmpy")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value The description of an X509 CA Certificate.
     */
    @JvmName("jtehcoqjfilnrmaw")
    public suspend fun properties(`value`: CertificatePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The description of an X509 CA Certificate.
     */
    @JvmName("roodaeqnadcmxsmg")
    public suspend fun properties(argument: suspend CertificatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CertificatePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the IoT hub.
     */
    @JvmName("jkdhoneqkcccudlp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the IoT hub.
     */
    @JvmName("afqfuemsfspyymsi")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        certificateName = certificateName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
