@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.azurenative.devices.kotlin.outputs.ArmIdentityResponse
import com.pulumi.azurenative.devices.kotlin.outputs.IotHubPropertiesResponse
import com.pulumi.azurenative.devices.kotlin.outputs.IotHubSkuInfoResponse
import com.pulumi.azurenative.devices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devices.kotlin.outputs.ArmIdentityResponse.Companion.toKotlin as armIdentityResponseToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.IotHubPropertiesResponse.Companion.toKotlin as iotHubPropertiesResponseToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.IotHubSkuInfoResponse.Companion.toKotlin as iotHubSkuInfoResponseToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [IotHubResource].
 */
@PulumiTagMarker
public class IotHubResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IotHubResourceArgs = IotHubResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IotHubResourceArgsBuilder.() -> Unit) {
        val builder = IotHubResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IotHubResource {
        val builtJavaResource = com.pulumi.azurenative.devices.IotHubResource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IotHubResource(builtJavaResource)
    }
}

/**
 * The description of the IoT hub.
 * Azure REST API version: 2022-04-30-preview. Prior API version in Azure Native 1.x: 2020-08-31.
 * Other available API versions: 2017-07-01, 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
 * ## Example Usage
 * ### IotHubResource_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotHubResource = new AzureNative.Devices.IotHubResource("iotHubResource", new()
 *     {
 *         Location = "centraluseuap",
 *         Properties = new AzureNative.Devices.Inputs.IotHubPropertiesArgs
 *         {
 *             CloudToDevice = new AzureNative.Devices.Inputs.CloudToDevicePropertiesArgs
 *             {
 *                 DefaultTtlAsIso8601 = "PT1H",
 *                 Feedback = new AzureNative.Devices.Inputs.FeedbackPropertiesArgs
 *                 {
 *                     LockDurationAsIso8601 = "PT1M",
 *                     MaxDeliveryCount = 10,
 *                     TtlAsIso8601 = "PT1H",
 *                 },
 *                 MaxDeliveryCount = 10,
 *             },
 *             EnableDataResidency = true,
 *             EnableFileUploadNotifications = false,
 *             EventHubEndpoints =
 *             {
 *                 { "events", new AzureNative.Devices.Inputs.EventHubPropertiesArgs
 *                 {
 *                     PartitionCount = 2,
 *                     RetentionTimeInDays = 1,
 *                 } },
 *             },
 *             Features = "None",
 *             IpFilterRules = new() { },
 *             MessagingEndpoints =
 *             {
 *                 { "fileNotifications", new AzureNative.Devices.Inputs.MessagingEndpointPropertiesArgs
 *                 {
 *                     LockDurationAsIso8601 = "PT1M",
 *                     MaxDeliveryCount = 10,
 *                     TtlAsIso8601 = "PT1H",
 *                 } },
 *             },
 *             MinTlsVersion = "1.2",
 *             NetworkRuleSets = new AzureNative.Devices.Inputs.NetworkRuleSetPropertiesArgs
 *             {
 *                 ApplyToBuiltInEventHubEndpoint = true,
 *                 DefaultAction = "Deny",
 *                 IpRules = new[]
 *                 {
 *                     new AzureNative.Devices.Inputs.NetworkRuleSetIpRuleArgs
 *                     {
 *                         Action = "Allow",
 *                         FilterName = "rule1",
 *                         IpMask = "131.117.159.53",
 *                     },
 *                     new AzureNative.Devices.Inputs.NetworkRuleSetIpRuleArgs
 *                     {
 *                         Action = "Allow",
 *                         FilterName = "rule2",
 *                         IpMask = "157.55.59.128/25",
 *                     },
 *                 },
 *             },
 *             RootCertificate = new AzureNative.Devices.Inputs.RootCertificatePropertiesArgs
 *             {
 *                 EnableRootCertificateV2 = true,
 *             },
 *             Routing = new AzureNative.Devices.Inputs.RoutingPropertiesArgs
 *             {
 *                 Endpoints = new AzureNative.Devices.Inputs.RoutingEndpointsArgs
 *                 {
 *                     EventHubs = new[] {},
 *                     ServiceBusQueues = new[] {},
 *                     ServiceBusTopics = new[] {},
 *                     StorageContainers = new[] {},
 *                 },
 *                 FallbackRoute = new AzureNative.Devices.Inputs.FallbackRoutePropertiesArgs
 *                 {
 *                     Condition = "true",
 *                     EndpointNames = new[]
 *                     {
 *                         "events",
 *                     },
 *                     IsEnabled = true,
 *                     Name = "$fallback",
 *                     Source = "DeviceMessages",
 *                 },
 *                 Routes = new[] {},
 *             },
 *             StorageEndpoints =
 *             {
 *                 { "$default", new AzureNative.Devices.Inputs.StorageEndpointPropertiesArgs
 *                 {
 *                     ConnectionString = "",
 *                     ContainerName = "",
 *                     SasTtlAsIso8601 = "PT1H",
 *                 } },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "testHub",
 *         Sku = new AzureNative.Devices.Inputs.IotHubSkuInfoArgs
 *         {
 *             Capacity = 1,
 *             Name = "S1",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := devices.NewIotHubResource(ctx, "iotHubResource", &devices.IotHubResourceArgs{
 * Location: pulumi.String("centraluseuap"),
 * Properties: devices.IotHubPropertiesResponse{
 * CloudToDevice: interface{}{
 * DefaultTtlAsIso8601: pulumi.String("PT1H"),
 * Feedback: &devices.FeedbackPropertiesArgs{
 * LockDurationAsIso8601: pulumi.String("PT1M"),
 * MaxDeliveryCount: pulumi.Int(10),
 * TtlAsIso8601: pulumi.String("PT1H"),
 * },
 * MaxDeliveryCount: pulumi.Int(10),
 * },
 * EnableDataResidency: pulumi.Bool(true),
 * EnableFileUploadNotifications: pulumi.Bool(false),
 * EventHubEndpoints: devices.EventHubPropertiesMap{
 * "events": &devices.EventHubPropertiesArgs{
 * PartitionCount: pulumi.Int(2),
 * RetentionTimeInDays: pulumi.Float64(1),
 * },
 * },
 * Features: pulumi.String("None"),
 * IpFilterRules: devices.IpFilterRuleArray{
 * },
 * MessagingEndpoints: devices.MessagingEndpointPropertiesMap{
 * "fileNotifications": &devices.MessagingEndpointPropertiesArgs{
 * LockDurationAsIso8601: pulumi.String("PT1M"),
 * MaxDeliveryCount: pulumi.Int(10),
 * TtlAsIso8601: pulumi.String("PT1H"),
 * },
 * },
 * MinTlsVersion: pulumi.String("1.2"),
 * NetworkRuleSets: interface{}{
 * ApplyToBuiltInEventHubEndpoint: pulumi.Bool(true),
 * DefaultAction: pulumi.String("Deny"),
 * IpRules: devices.NetworkRuleSetIpRuleArray{
 * &devices.NetworkRuleSetIpRuleArgs{
 * Action: pulumi.String("Allow"),
 * FilterName: pulumi.String("rule1"),
 * IpMask: pulumi.String("131.117.159.53"),
 * },
 * &devices.NetworkRuleSetIpRuleArgs{
 * Action: pulumi.String("Allow"),
 * FilterName: pulumi.String("rule2"),
 * IpMask: pulumi.String("157.55.59.128/25"),
 * },
 * },
 * },
 * RootCertificate: &devices.RootCertificatePropertiesArgs{
 * EnableRootCertificateV2: pulumi.Bool(true),
 * },
 * Routing: interface{}{
 * Endpoints: interface{}{
 * EventHubs: devices.RoutingEventHubPropertiesArray{
 * },
 * ServiceBusQueues: devices.RoutingServiceBusQueueEndpointPropertiesArray{
 * },
 * ServiceBusTopics: devices.RoutingServiceBusTopicEndpointPropertiesArray{
 * },
 * StorageContainers: devices.RoutingStorageContainerPropertiesArray{
 * },
 * },
 * FallbackRoute: &devices.FallbackRoutePropertiesArgs{
 * Condition: pulumi.String("true"),
 * EndpointNames: pulumi.StringArray{
 * pulumi.String("events"),
 * },
 * IsEnabled: pulumi.Bool(true),
 * Name: pulumi.String("$fallback"),
 * Source: pulumi.String("DeviceMessages"),
 * },
 * Routes: devices.RoutePropertiesArray{
 * },
 * },
 * StorageEndpoints: devices.StorageEndpointPropertiesMap{
 * "$default": &devices.StorageEndpointPropertiesArgs{
 * ConnectionString: pulumi.String(""),
 * ContainerName: pulumi.String(""),
 * SasTtlAsIso8601: pulumi.String("PT1H"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ResourceName: pulumi.String("testHub"),
 * Sku: &devices.IotHubSkuInfoArgs{
 * Capacity: pulumi.Float64(1),
 * Name: pulumi.String("S1"),
 * },
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devices.IotHubResource;
 * import com.pulumi.azurenative.devices.IotHubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotHubResource = new IotHubResource("iotHubResource", IotHubResourceArgs.builder()
 *             .location("centraluseuap")
 *             .properties(Map.ofEntries(
 *                 Map.entry("cloudToDevice", Map.ofEntries(
 *                     Map.entry("defaultTtlAsIso8601", "PT1H"),
 *                     Map.entry("feedback", Map.ofEntries(
 *                         Map.entry("lockDurationAsIso8601", "PT1M"),
 *                         Map.entry("maxDeliveryCount", 10),
 *                         Map.entry("ttlAsIso8601", "PT1H")
 *                     )),
 *                     Map.entry("maxDeliveryCount", 10)
 *                 )),
 *                 Map.entry("enableDataResidency", true),
 *                 Map.entry("enableFileUploadNotifications", false),
 *                 Map.entry("eventHubEndpoints", Map.of("events", Map.ofEntries(
 *                     Map.entry("partitionCount", 2),
 *                     Map.entry("retentionTimeInDays", 1)
 *                 ))),
 *                 Map.entry("features", "None"),
 *                 Map.entry("ipFilterRules", ),
 *                 Map.entry("messagingEndpoints", Map.of("fileNotifications", Map.ofEntries(
 *                     Map.entry("lockDurationAsIso8601", "PT1M"),
 *                     Map.entry("maxDeliveryCount", 10),
 *                     Map.entry("ttlAsIso8601", "PT1H")
 *                 ))),
 *                 Map.entry("minTlsVersion", "1.2"),
 *                 Map.entry("networkRuleSets", Map.ofEntries(
 *                     Map.entry("applyToBuiltInEventHubEndpoint", true),
 *                     Map.entry("defaultAction", "Deny"),
 *                     Map.entry("ipRules",
 *                         Map.ofEntries(
 *                             Map.entry("action", "Allow"),
 *                             Map.entry("filterName", "rule1"),
 *                             Map.entry("ipMask", "131.117.159.53")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("action", "Allow"),
 *                             Map.entry("filterName", "rule2"),
 *                             Map.entry("ipMask", "157.55.59.128/25")
 *                         ))
 *                 )),
 *                 Map.entry("rootCertificate", Map.of("enableRootCertificateV2", true)),
 *                 Map.entry("routing", Map.ofEntries(
 *                     Map.entry("endpoints", Map.ofEntries(
 *                         Map.entry("eventHubs", ),
 *                         Map.entry("serviceBusQueues", ),
 *                         Map.entry("serviceBusTopics", ),
 *                         Map.entry("storageContainers", )
 *                     )),
 *                     Map.entry("fallbackRoute", Map.ofEntries(
 *                         Map.entry("condition", "true"),
 *                         Map.entry("endpointNames", "events"),
 *                         Map.entry("isEnabled", true),
 *                         Map.entry("name", "$fallback"),
 *                         Map.entry("source", "DeviceMessages")
 *                     )),
 *                     Map.entry("routes", )
 *                 )),
 *                 Map.entry("storageEndpoints", Map.of("$default", Map.ofEntries(
 *                     Map.entry("connectionString", ""),
 *                     Map.entry("containerName", ""),
 *                     Map.entry("sasTtlAsIso8601", "PT1H")
 *                 )))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("testHub")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "S1")
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devices:IotHubResource testHub /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}
 * ```
 */
public class IotHubResource internal constructor(
    override val javaResource: com.pulumi.azurenative.devices.IotHubResource,
) : KotlinCustomResource(javaResource, IotHubResourceMapper) {
    /**
     * The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The managed identities for the IotHub.
     */
    public val identity: Output<ArmIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    armIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * IotHub properties
     */
    public val properties: Output<IotHubPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                iotHubPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * IotHub SKU info
     */
    public val sku: Output<IotHubSkuInfoResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                iotHubSkuInfoResponseToKotlin(args0)
            })
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IotHubResourceMapper : ResourceMapper<IotHubResource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devices.IotHubResource::class == javaResource::class

    override fun map(javaResource: Resource): IotHubResource = IotHubResource(
        javaResource as
            com.pulumi.azurenative.devices.IotHubResource,
    )
}

/**
 * @see [IotHubResource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IotHubResource].
 */
public suspend fun iotHubResource(
    name: String,
    block: suspend IotHubResourceResourceBuilder.() -> Unit,
): IotHubResource {
    val builder = IotHubResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IotHubResource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iotHubResource(name: String): IotHubResource {
    val builder = IotHubResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
