@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.azurenative.devices.IotHubResourceArgs.builder
import com.pulumi.azurenative.devices.kotlin.inputs.ArmIdentityArgs
import com.pulumi.azurenative.devices.kotlin.inputs.ArmIdentityArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.IotHubPropertiesArgs
import com.pulumi.azurenative.devices.kotlin.inputs.IotHubPropertiesArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.IotHubSkuInfoArgs
import com.pulumi.azurenative.devices.kotlin.inputs.IotHubSkuInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The description of the IoT hub.
 * Azure REST API version: 2022-04-30-preview. Prior API version in Azure Native 1.x: 2020-08-31.
 * Other available API versions: 2017-07-01, 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
 * ## Example Usage
 * ### IotHubResource_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotHubResource = new AzureNative.Devices.IotHubResource("iotHubResource", new()
 *     {
 *         Location = "centraluseuap",
 *         Properties = new AzureNative.Devices.Inputs.IotHubPropertiesArgs
 *         {
 *             CloudToDevice = new AzureNative.Devices.Inputs.CloudToDevicePropertiesArgs
 *             {
 *                 DefaultTtlAsIso8601 = "PT1H",
 *                 Feedback = new AzureNative.Devices.Inputs.FeedbackPropertiesArgs
 *                 {
 *                     LockDurationAsIso8601 = "PT1M",
 *                     MaxDeliveryCount = 10,
 *                     TtlAsIso8601 = "PT1H",
 *                 },
 *                 MaxDeliveryCount = 10,
 *             },
 *             EnableDataResidency = true,
 *             EnableFileUploadNotifications = false,
 *             EventHubEndpoints =
 *             {
 *                 { "events", new AzureNative.Devices.Inputs.EventHubPropertiesArgs
 *                 {
 *                     PartitionCount = 2,
 *                     RetentionTimeInDays = 1,
 *                 } },
 *             },
 *             Features = "None",
 *             IpFilterRules = new() { },
 *             MessagingEndpoints =
 *             {
 *                 { "fileNotifications", new AzureNative.Devices.Inputs.MessagingEndpointPropertiesArgs
 *                 {
 *                     LockDurationAsIso8601 = "PT1M",
 *                     MaxDeliveryCount = 10,
 *                     TtlAsIso8601 = "PT1H",
 *                 } },
 *             },
 *             MinTlsVersion = "1.2",
 *             NetworkRuleSets = new AzureNative.Devices.Inputs.NetworkRuleSetPropertiesArgs
 *             {
 *                 ApplyToBuiltInEventHubEndpoint = true,
 *                 DefaultAction = "Deny",
 *                 IpRules = new[]
 *                 {
 *                     new AzureNative.Devices.Inputs.NetworkRuleSetIpRuleArgs
 *                     {
 *                         Action = "Allow",
 *                         FilterName = "rule1",
 *                         IpMask = "131.117.159.53",
 *                     },
 *                     new AzureNative.Devices.Inputs.NetworkRuleSetIpRuleArgs
 *                     {
 *                         Action = "Allow",
 *                         FilterName = "rule2",
 *                         IpMask = "157.55.59.128/25",
 *                     },
 *                 },
 *             },
 *             RootCertificate = new AzureNative.Devices.Inputs.RootCertificatePropertiesArgs
 *             {
 *                 EnableRootCertificateV2 = true,
 *             },
 *             Routing = new AzureNative.Devices.Inputs.RoutingPropertiesArgs
 *             {
 *                 Endpoints = new AzureNative.Devices.Inputs.RoutingEndpointsArgs
 *                 {
 *                     EventHubs = new[] {},
 *                     ServiceBusQueues = new[] {},
 *                     ServiceBusTopics = new[] {},
 *                     StorageContainers = new[] {},
 *                 },
 *                 FallbackRoute = new AzureNative.Devices.Inputs.FallbackRoutePropertiesArgs
 *                 {
 *                     Condition = "true",
 *                     EndpointNames = new[]
 *                     {
 *                         "events",
 *                     },
 *                     IsEnabled = true,
 *                     Name = "$fallback",
 *                     Source = "DeviceMessages",
 *                 },
 *                 Routes = new[] {},
 *             },
 *             StorageEndpoints =
 *             {
 *                 { "$default", new AzureNative.Devices.Inputs.StorageEndpointPropertiesArgs
 *                 {
 *                     ConnectionString = "",
 *                     ContainerName = "",
 *                     SasTtlAsIso8601 = "PT1H",
 *                 } },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "testHub",
 *         Sku = new AzureNative.Devices.Inputs.IotHubSkuInfoArgs
 *         {
 *             Capacity = 1,
 *             Name = "S1",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := devices.NewIotHubResource(ctx, "iotHubResource", &devices.IotHubResourceArgs{
 * Location: pulumi.String("centraluseuap"),
 * Properties: devices.IotHubPropertiesResponse{
 * CloudToDevice: interface{}{
 * DefaultTtlAsIso8601: pulumi.String("PT1H"),
 * Feedback: &devices.FeedbackPropertiesArgs{
 * LockDurationAsIso8601: pulumi.String("PT1M"),
 * MaxDeliveryCount: pulumi.Int(10),
 * TtlAsIso8601: pulumi.String("PT1H"),
 * },
 * MaxDeliveryCount: pulumi.Int(10),
 * },
 * EnableDataResidency: pulumi.Bool(true),
 * EnableFileUploadNotifications: pulumi.Bool(false),
 * EventHubEndpoints: devices.EventHubPropertiesMap{
 * "events": &devices.EventHubPropertiesArgs{
 * PartitionCount: pulumi.Int(2),
 * RetentionTimeInDays: pulumi.Float64(1),
 * },
 * },
 * Features: pulumi.String("None"),
 * IpFilterRules: devices.IpFilterRuleArray{
 * },
 * MessagingEndpoints: devices.MessagingEndpointPropertiesMap{
 * "fileNotifications": &devices.MessagingEndpointPropertiesArgs{
 * LockDurationAsIso8601: pulumi.String("PT1M"),
 * MaxDeliveryCount: pulumi.Int(10),
 * TtlAsIso8601: pulumi.String("PT1H"),
 * },
 * },
 * MinTlsVersion: pulumi.String("1.2"),
 * NetworkRuleSets: interface{}{
 * ApplyToBuiltInEventHubEndpoint: pulumi.Bool(true),
 * DefaultAction: pulumi.String("Deny"),
 * IpRules: devices.NetworkRuleSetIpRuleArray{
 * &devices.NetworkRuleSetIpRuleArgs{
 * Action: pulumi.String("Allow"),
 * FilterName: pulumi.String("rule1"),
 * IpMask: pulumi.String("131.117.159.53"),
 * },
 * &devices.NetworkRuleSetIpRuleArgs{
 * Action: pulumi.String("Allow"),
 * FilterName: pulumi.String("rule2"),
 * IpMask: pulumi.String("157.55.59.128/25"),
 * },
 * },
 * },
 * RootCertificate: &devices.RootCertificatePropertiesArgs{
 * EnableRootCertificateV2: pulumi.Bool(true),
 * },
 * Routing: interface{}{
 * Endpoints: interface{}{
 * EventHubs: devices.RoutingEventHubPropertiesArray{
 * },
 * ServiceBusQueues: devices.RoutingServiceBusQueueEndpointPropertiesArray{
 * },
 * ServiceBusTopics: devices.RoutingServiceBusTopicEndpointPropertiesArray{
 * },
 * StorageContainers: devices.RoutingStorageContainerPropertiesArray{
 * },
 * },
 * FallbackRoute: &devices.FallbackRoutePropertiesArgs{
 * Condition: pulumi.String("true"),
 * EndpointNames: pulumi.StringArray{
 * pulumi.String("events"),
 * },
 * IsEnabled: pulumi.Bool(true),
 * Name: pulumi.String("$fallback"),
 * Source: pulumi.String("DeviceMessages"),
 * },
 * Routes: devices.RoutePropertiesArray{
 * },
 * },
 * StorageEndpoints: devices.StorageEndpointPropertiesMap{
 * "$default": &devices.StorageEndpointPropertiesArgs{
 * ConnectionString: pulumi.String(""),
 * ContainerName: pulumi.String(""),
 * SasTtlAsIso8601: pulumi.String("PT1H"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ResourceName: pulumi.String("testHub"),
 * Sku: &devices.IotHubSkuInfoArgs{
 * Capacity: pulumi.Float64(1),
 * Name: pulumi.String("S1"),
 * },
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devices.IotHubResource;
 * import com.pulumi.azurenative.devices.IotHubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotHubResource = new IotHubResource("iotHubResource", IotHubResourceArgs.builder()
 *             .location("centraluseuap")
 *             .properties(Map.ofEntries(
 *                 Map.entry("cloudToDevice", Map.ofEntries(
 *                     Map.entry("defaultTtlAsIso8601", "PT1H"),
 *                     Map.entry("feedback", Map.ofEntries(
 *                         Map.entry("lockDurationAsIso8601", "PT1M"),
 *                         Map.entry("maxDeliveryCount", 10),
 *                         Map.entry("ttlAsIso8601", "PT1H")
 *                     )),
 *                     Map.entry("maxDeliveryCount", 10)
 *                 )),
 *                 Map.entry("enableDataResidency", true),
 *                 Map.entry("enableFileUploadNotifications", false),
 *                 Map.entry("eventHubEndpoints", Map.of("events", Map.ofEntries(
 *                     Map.entry("partitionCount", 2),
 *                     Map.entry("retentionTimeInDays", 1)
 *                 ))),
 *                 Map.entry("features", "None"),
 *                 Map.entry("ipFilterRules", ),
 *                 Map.entry("messagingEndpoints", Map.of("fileNotifications", Map.ofEntries(
 *                     Map.entry("lockDurationAsIso8601", "PT1M"),
 *                     Map.entry("maxDeliveryCount", 10),
 *                     Map.entry("ttlAsIso8601", "PT1H")
 *                 ))),
 *                 Map.entry("minTlsVersion", "1.2"),
 *                 Map.entry("networkRuleSets", Map.ofEntries(
 *                     Map.entry("applyToBuiltInEventHubEndpoint", true),
 *                     Map.entry("defaultAction", "Deny"),
 *                     Map.entry("ipRules",
 *                         Map.ofEntries(
 *                             Map.entry("action", "Allow"),
 *                             Map.entry("filterName", "rule1"),
 *                             Map.entry("ipMask", "131.117.159.53")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("action", "Allow"),
 *                             Map.entry("filterName", "rule2"),
 *                             Map.entry("ipMask", "157.55.59.128/25")
 *                         ))
 *                 )),
 *                 Map.entry("rootCertificate", Map.of("enableRootCertificateV2", true)),
 *                 Map.entry("routing", Map.ofEntries(
 *                     Map.entry("endpoints", Map.ofEntries(
 *                         Map.entry("eventHubs", ),
 *                         Map.entry("serviceBusQueues", ),
 *                         Map.entry("serviceBusTopics", ),
 *                         Map.entry("storageContainers", )
 *                     )),
 *                     Map.entry("fallbackRoute", Map.ofEntries(
 *                         Map.entry("condition", "true"),
 *                         Map.entry("endpointNames", "events"),
 *                         Map.entry("isEnabled", true),
 *                         Map.entry("name", "$fallback"),
 *                         Map.entry("source", "DeviceMessages")
 *                     )),
 *                     Map.entry("routes", )
 *                 )),
 *                 Map.entry("storageEndpoints", Map.of("$default", Map.ofEntries(
 *                     Map.entry("connectionString", ""),
 *                     Map.entry("containerName", ""),
 *                     Map.entry("sasTtlAsIso8601", "PT1H")
 *                 )))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("testHub")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "S1")
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devices:IotHubResource testHub /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}
 * ```
 * @property identity The managed identities for the IotHub.
 * @property location The resource location.
 * @property properties IotHub properties
 * @property resourceGroupName The name of the resource group that contains the IoT hub.
 * @property resourceName The name of the IoT hub.
 * @property sku IotHub SKU info
 * @property tags The resource tags.
 */
public data class IotHubResourceArgs(
    public val identity: Output<ArmIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<IotHubPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val sku: Output<IotHubSkuInfoArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.IotHubResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.IotHubResourceArgs =
        com.pulumi.azurenative.devices.IotHubResourceArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IotHubResourceArgs].
 */
@PulumiTagMarker
public class IotHubResourceArgsBuilder internal constructor() {
    private var identity: Output<ArmIdentityArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<IotHubPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var sku: Output<IotHubSkuInfoArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The managed identities for the IotHub.
     */
    @JvmName("cbobrkkmxexgrglm")
    public suspend fun identity(`value`: Output<ArmIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("fkixjeckapdpsxas")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value IotHub properties
     */
    @JvmName("mjxdprbvxooyuwoy")
    public suspend fun properties(`value`: Output<IotHubPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the IoT hub.
     */
    @JvmName("lbieryccspafhmns")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the IoT hub.
     */
    @JvmName("okddyllpyhunooud")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value IotHub SKU info
     */
    @JvmName("ftpysxisikkloypv")
    public suspend fun sku(`value`: Output<IotHubSkuInfoArgs>) {
        this.sku = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("jippnbpdcjatcpwk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The managed identities for the IotHub.
     */
    @JvmName("mquwpudoekvggiag")
    public suspend fun identity(`value`: ArmIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed identities for the IotHub.
     */
    @JvmName("hkjbkdsqhaqkiakk")
    public suspend fun identity(argument: suspend ArmIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ArmIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("rtypvpvhesgvvuof")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value IotHub properties
     */
    @JvmName("wlksfqvqnrqlxrbo")
    public suspend fun properties(`value`: IotHubPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument IotHub properties
     */
    @JvmName("ueedbyjphqxlptkt")
    public suspend fun properties(argument: suspend IotHubPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IotHubPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the IoT hub.
     */
    @JvmName("ubgkexlxomsxbpuc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the IoT hub.
     */
    @JvmName("ywhxwcujgpdaghua")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value IotHub SKU info
     */
    @JvmName("wlwhmfywoamvtcyw")
    public suspend fun sku(`value`: IotHubSkuInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument IotHub SKU info
     */
    @JvmName("jncdgleyfbncixhc")
    public suspend fun sku(argument: suspend IotHubSkuInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IotHubSkuInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("flsuotabtiddhoif")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("shvuadehaxcxqtpu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IotHubResourceArgs = IotHubResourceArgs(
        identity = identity,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        sku = sku,
        tags = tags,
    )
}
