@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroupArgs.builder
import com.pulumi.azurenative.devices.kotlin.inputs.EventHubConsumerGroupNameArgs
import com.pulumi.azurenative.devices.kotlin.inputs.EventHubConsumerGroupNameArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of the EventHubConsumerGroupInfo object.
 * Azure REST API version: 2022-04-30-preview. Prior API version in Azure Native 1.x: 2020-08-31.
 * Other available API versions: 2017-07-01, 2021-03-03-preview, 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
 * ## Example Usage
 * ### IotHubResource_CreateEventHubConsumerGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotHubResourceEventHubConsumerGroup = new AzureNative.Devices.IotHubResourceEventHubConsumerGroup("iotHubResourceEventHubConsumerGroup", new()
 *     {
 *         EventHubEndpointName = "events",
 *         Name = "test",
 *         Properties = new AzureNative.Devices.Inputs.EventHubConsumerGroupNameArgs
 *         {
 *             Name = "test",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "testHub",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devices.NewIotHubResourceEventHubConsumerGroup(ctx, "iotHubResourceEventHubConsumerGroup", &devices.IotHubResourceEventHubConsumerGroupArgs{
 * 			EventHubEndpointName: pulumi.String("events"),
 * 			Name:                 pulumi.String("test"),
 * 			Properties: &devices.EventHubConsumerGroupNameArgs{
 * 				Name: pulumi.String("test"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("testHub"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroup;
 * import com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotHubResourceEventHubConsumerGroup = new IotHubResourceEventHubConsumerGroup("iotHubResourceEventHubConsumerGroup", IotHubResourceEventHubConsumerGroupArgs.builder()
 *             .eventHubEndpointName("events")
 *             .name("test")
 *             .properties(Map.of("name", "test"))
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("testHub")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devices:IotHubResourceEventHubConsumerGroup test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}
 * ```
 * @property eventHubEndpointName The name of the Event Hub-compatible endpoint in the IoT hub.
 * @property name The name of the consumer group to add.
 * @property properties The EventHub consumer group name.
 * @property resourceGroupName The name of the resource group that contains the IoT hub.
 * @property resourceName The name of the IoT hub.
 */
public data class IotHubResourceEventHubConsumerGroupArgs(
    public val eventHubEndpointName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<EventHubConsumerGroupNameArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroupArgs =
        com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroupArgs.builder()
            .eventHubEndpointName(eventHubEndpointName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IotHubResourceEventHubConsumerGroupArgs].
 */
@PulumiTagMarker
public class IotHubResourceEventHubConsumerGroupArgsBuilder internal constructor() {
    private var eventHubEndpointName: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<EventHubConsumerGroupNameArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value The name of the Event Hub-compatible endpoint in the IoT hub.
     */
    @JvmName("wnokyalklpcnrpcl")
    public suspend fun eventHubEndpointName(`value`: Output<String>) {
        this.eventHubEndpointName = value
    }

    /**
     * @param value The name of the consumer group to add.
     */
    @JvmName("htnliqoefnpmlqxp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The EventHub consumer group name.
     */
    @JvmName("qxmlbgivvdmokhwv")
    public suspend fun properties(`value`: Output<EventHubConsumerGroupNameArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the IoT hub.
     */
    @JvmName("xtfexxohyghttacj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the IoT hub.
     */
    @JvmName("otqqqcasudpwuega")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The name of the Event Hub-compatible endpoint in the IoT hub.
     */
    @JvmName("avvyilfdpenhjmrc")
    public suspend fun eventHubEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubEndpointName = mapped
    }

    /**
     * @param value The name of the consumer group to add.
     */
    @JvmName("mibrfmsdaioynkaw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The EventHub consumer group name.
     */
    @JvmName("wtcfiuskpefhkdhm")
    public suspend fun properties(`value`: EventHubConsumerGroupNameArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The EventHub consumer group name.
     */
    @JvmName("lqhawhfxkihmhjry")
    public suspend fun properties(argument: suspend EventHubConsumerGroupNameArgsBuilder.() -> Unit) {
        val toBeMapped = EventHubConsumerGroupNameArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the IoT hub.
     */
    @JvmName("cxajvofrlvawjsyf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the IoT hub.
     */
    @JvmName("cuixoxfivuebjnds")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): IotHubResourceEventHubConsumerGroupArgs =
        IotHubResourceEventHubConsumerGroupArgs(
            eventHubEndpointName = eventHubEndpointName,
            name = name,
            properties = properties,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
}
