@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.CertificatePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The description of an X509 CA Certificate.
 * @property certificate base-64 representation of X509 certificate .cer file or just .pem file content.
 * @property isVerified Determines whether certificate has been verified.
 */
public data class CertificatePropertiesArgs(
    public val certificate: Output<String>? = null,
    public val isVerified: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.CertificatePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.CertificatePropertiesArgs =
        com.pulumi.azurenative.devices.inputs.CertificatePropertiesArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .isVerified(isVerified?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificatePropertiesArgs].
 */
@PulumiTagMarker
public class CertificatePropertiesArgsBuilder internal constructor() {
    private var certificate: Output<String>? = null

    private var isVerified: Output<Boolean>? = null

    /**
     * @param value base-64 representation of X509 certificate .cer file or just .pem file content.
     */
    @JvmName("pwxsxcuurwsewibn")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value Determines whether certificate has been verified.
     */
    @JvmName("oaygwinswlxxwglx")
    public suspend fun isVerified(`value`: Output<Boolean>) {
        this.isVerified = value
    }

    /**
     * @param value base-64 representation of X509 certificate .cer file or just .pem file content.
     */
    @JvmName("hiemawchsjvfxrlc")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value Determines whether certificate has been verified.
     */
    @JvmName("gbaivtevrxjrhvfd")
    public suspend fun isVerified(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isVerified = mapped
    }

    internal fun build(): CertificatePropertiesArgs = CertificatePropertiesArgs(
        certificate = certificate,
        isVerified = isVerified,
    )
}
