@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.CloudToDevicePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The IoT hub cloud-to-device messaging properties.
 * @property defaultTtlAsIso8601 The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
 * @property feedback The properties of the feedback queue for cloud-to-device messages.
 * @property maxDeliveryCount The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
 */
public data class CloudToDevicePropertiesArgs(
    public val defaultTtlAsIso8601: Output<String>? = null,
    public val feedback: Output<FeedbackPropertiesArgs>? = null,
    public val maxDeliveryCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.CloudToDevicePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.CloudToDevicePropertiesArgs =
        com.pulumi.azurenative.devices.inputs.CloudToDevicePropertiesArgs.builder()
            .defaultTtlAsIso8601(defaultTtlAsIso8601?.applyValue({ args0 -> args0 }))
            .feedback(feedback?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxDeliveryCount(maxDeliveryCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudToDevicePropertiesArgs].
 */
@PulumiTagMarker
public class CloudToDevicePropertiesArgsBuilder internal constructor() {
    private var defaultTtlAsIso8601: Output<String>? = null

    private var feedback: Output<FeedbackPropertiesArgs>? = null

    private var maxDeliveryCount: Output<Int>? = null

    /**
     * @param value The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
     */
    @JvmName("ulkpbyhsnpqsntsk")
    public suspend fun defaultTtlAsIso8601(`value`: Output<String>) {
        this.defaultTtlAsIso8601 = value
    }

    /**
     * @param value The properties of the feedback queue for cloud-to-device messages.
     */
    @JvmName("ghfcfflrgqhawktc")
    public suspend fun feedback(`value`: Output<FeedbackPropertiesArgs>) {
        this.feedback = value
    }

    /**
     * @param value The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
     */
    @JvmName("fpmmsexxfypystse")
    public suspend fun maxDeliveryCount(`value`: Output<Int>) {
        this.maxDeliveryCount = value
    }

    /**
     * @param value The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
     */
    @JvmName("pdmjlalqvmnycbki")
    public suspend fun defaultTtlAsIso8601(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTtlAsIso8601 = mapped
    }

    /**
     * @param value The properties of the feedback queue for cloud-to-device messages.
     */
    @JvmName("rudtuohywuwcjlmv")
    public suspend fun feedback(`value`: FeedbackPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.feedback = mapped
    }

    /**
     * @param argument The properties of the feedback queue for cloud-to-device messages.
     */
    @JvmName("sppqdgvqdfrqqqyt")
    public suspend fun feedback(argument: suspend FeedbackPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = FeedbackPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.feedback = mapped
    }

    /**
     * @param value The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
     */
    @JvmName("rsywvatpdyrnoroa")
    public suspend fun maxDeliveryCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDeliveryCount = mapped
    }

    internal fun build(): CloudToDevicePropertiesArgs = CloudToDevicePropertiesArgs(
        defaultTtlAsIso8601 = defaultTtlAsIso8601,
        feedback = feedback,
        maxDeliveryCount = maxDeliveryCount,
    )
}
