@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.FeedbackPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the feedback queue for cloud-to-device messages.
 * @property lockDurationAsIso8601 The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
 * @property maxDeliveryCount The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
 * @property ttlAsIso8601 The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
 */
public data class FeedbackPropertiesArgs(
    public val lockDurationAsIso8601: Output<String>? = null,
    public val maxDeliveryCount: Output<Int>? = null,
    public val ttlAsIso8601: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.FeedbackPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.FeedbackPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.FeedbackPropertiesArgs.builder()
            .lockDurationAsIso8601(lockDurationAsIso8601?.applyValue({ args0 -> args0 }))
            .maxDeliveryCount(maxDeliveryCount?.applyValue({ args0 -> args0 }))
            .ttlAsIso8601(ttlAsIso8601?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeedbackPropertiesArgs].
 */
@PulumiTagMarker
public class FeedbackPropertiesArgsBuilder internal constructor() {
    private var lockDurationAsIso8601: Output<String>? = null

    private var maxDeliveryCount: Output<Int>? = null

    private var ttlAsIso8601: Output<String>? = null

    /**
     * @param value The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
     */
    @JvmName("eoggjbookbhwjlhr")
    public suspend fun lockDurationAsIso8601(`value`: Output<String>) {
        this.lockDurationAsIso8601 = value
    }

    /**
     * @param value The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
     */
    @JvmName("nnmklryvqrxqmrkw")
    public suspend fun maxDeliveryCount(`value`: Output<Int>) {
        this.maxDeliveryCount = value
    }

    /**
     * @param value The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
     */
    @JvmName("niwwqeyxesgvnqwv")
    public suspend fun ttlAsIso8601(`value`: Output<String>) {
        this.ttlAsIso8601 = value
    }

    /**
     * @param value The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
     */
    @JvmName("huvwwdokrqiwovan")
    public suspend fun lockDurationAsIso8601(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lockDurationAsIso8601 = mapped
    }

    /**
     * @param value The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
     */
    @JvmName("vferlvbpuhotqljh")
    public suspend fun maxDeliveryCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDeliveryCount = mapped
    }

    /**
     * @param value The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
     */
    @JvmName("redxhmaexvmlwdyq")
    public suspend fun ttlAsIso8601(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttlAsIso8601 = mapped
    }

    internal fun build(): FeedbackPropertiesArgs = FeedbackPropertiesArgs(
        lockDurationAsIso8601 = lockDurationAsIso8601,
        maxDeliveryCount = maxDeliveryCount,
        ttlAsIso8601 = ttlAsIso8601,
    )
}
