@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.GetIotDpsResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property provisioningServiceName Name of the provisioning service to retrieve.
 * @property resourceGroupName Resource group name.
 */
public data class GetIotDpsResourcePlainArgs(
    public val provisioningServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.GetIotDpsResourcePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.GetIotDpsResourcePlainArgs =
        com.pulumi.azurenative.devices.inputs.GetIotDpsResourcePlainArgs.builder()
            .provisioningServiceName(provisioningServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIotDpsResourcePlainArgs].
 */
@PulumiTagMarker
public class GetIotDpsResourcePlainArgsBuilder internal constructor() {
    private var provisioningServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the provisioning service to retrieve.
     */
    @JvmName("sqqbyjiwvetqkppq")
    public suspend fun provisioningServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.provisioningServiceName = mapped
    }

    /**
     * @param value Resource group name.
     */
    @JvmName("xjrqxvuxllqnawar")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIotDpsResourcePlainArgs = GetIotDpsResourcePlainArgs(
        provisioningServiceName = provisioningServiceName ?: throw
            PulumiNullFieldException("provisioningServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
