@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.GetIotHubResourceEventHubConsumerGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventHubEndpointName The name of the Event Hub-compatible endpoint in the IoT hub.
 * @property name The name of the consumer group to retrieve.
 * @property resourceGroupName The name of the resource group that contains the IoT hub.
 * @property resourceName The name of the IoT hub.
 */
public data class GetIotHubResourceEventHubConsumerGroupPlainArgs(
    public val eventHubEndpointName: String,
    public val name: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.devices.inputs.GetIotHubResourceEventHubConsumerGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.devices.inputs.GetIotHubResourceEventHubConsumerGroupPlainArgs =
        com.pulumi.azurenative.devices.inputs.GetIotHubResourceEventHubConsumerGroupPlainArgs.builder()
            .eventHubEndpointName(eventHubEndpointName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIotHubResourceEventHubConsumerGroupPlainArgs].
 */
@PulumiTagMarker
public class GetIotHubResourceEventHubConsumerGroupPlainArgsBuilder internal constructor() {
    private var eventHubEndpointName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the Event Hub-compatible endpoint in the IoT hub.
     */
    @JvmName("ajxbejigeiedhwqp")
    public suspend fun eventHubEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventHubEndpointName = mapped
    }

    /**
     * @param value The name of the consumer group to retrieve.
     */
    @JvmName("fnexcnctlyslttuh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group that contains the IoT hub.
     */
    @JvmName("jtvfkbjjqecyxcby")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the IoT hub.
     */
    @JvmName("ewrmqbujgtwxrqrw")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetIotHubResourceEventHubConsumerGroupPlainArgs =
        GetIotHubResourceEventHubConsumerGroupPlainArgs(
            eventHubEndpointName = eventHubEndpointName ?: throw
                PulumiNullFieldException("eventHubEndpointName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
