@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.IotDpsPropertiesDescriptionArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.AllocationPolicy
import com.pulumi.azurenative.devices.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.devices.kotlin.enums.State
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * the service specific properties of a provisioning service, including keys, linked iot hubs, current state, and system generated properties such as hostname and idScope
 * @property allocationPolicy Allocation policy to be used by this provisioning service.
 * @property authorizationPolicies List of authorization keys for a provisioning service.
 * @property enableDataResidency Optional.
 * Indicates if the DPS instance has Data Residency enabled, removing the cross geo-pair disaster recovery.
 * @property iotHubs List of IoT hubs associated with this provisioning service.
 * @property ipFilterRules The IP filter rules.
 * @property portalOperationsHostName Portal endpoint to enable CORS for this provisioning service.
 * @property privateEndpointConnections Private endpoint connections created on this IotHub
 * @property provisioningState The ARM provisioning state of the provisioning service.
 * @property publicNetworkAccess Whether requests from Public Network are allowed
 * @property state Current state of the provisioning service.
 */
public data class IotDpsPropertiesDescriptionArgs(
    public val allocationPolicy: Output<Either<String, AllocationPolicy>>? = null,
    public val authorizationPolicies:
    Output<List<SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs>>? = null,
    public val enableDataResidency: Output<Boolean>? = null,
    public val iotHubs: Output<List<IotHubDefinitionDescriptionArgs>>? = null,
    public val ipFilterRules: Output<List<TargetIpFilterRuleArgs>>? = null,
    public val portalOperationsHostName: Output<String>? = null,
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null,
    public val provisioningState: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val state: Output<Either<String, State>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.IotDpsPropertiesDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.IotDpsPropertiesDescriptionArgs =
        com.pulumi.azurenative.devices.inputs.IotDpsPropertiesDescriptionArgs.builder()
            .allocationPolicy(
                allocationPolicy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .authorizationPolicies(
                authorizationPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableDataResidency(enableDataResidency?.applyValue({ args0 -> args0 }))
            .iotHubs(
                iotHubs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipFilterRules(
                ipFilterRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .portalOperationsHostName(portalOperationsHostName?.applyValue({ args0 -> args0 }))
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IotDpsPropertiesDescriptionArgs].
 */
@PulumiTagMarker
public class IotDpsPropertiesDescriptionArgsBuilder internal constructor() {
    private var allocationPolicy: Output<Either<String, AllocationPolicy>>? = null

    private var authorizationPolicies:
        Output<List<SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs>>? = null

    private var enableDataResidency: Output<Boolean>? = null

    private var iotHubs: Output<List<IotHubDefinitionDescriptionArgs>>? = null

    private var ipFilterRules: Output<List<TargetIpFilterRuleArgs>>? = null

    private var portalOperationsHostName: Output<String>? = null

    private var privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null

    private var provisioningState: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var state: Output<Either<String, State>>? = null

    /**
     * @param value Allocation policy to be used by this provisioning service.
     */
    @JvmName("qrnakvynbkrwdugi")
    public suspend fun allocationPolicy(`value`: Output<Either<String, AllocationPolicy>>) {
        this.allocationPolicy = value
    }

    /**
     * @param value List of authorization keys for a provisioning service.
     */
    @JvmName("dbtdfmxckknufllb")
    public suspend
    fun authorizationPolicies(`value`: Output<List<SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs>>) {
        this.authorizationPolicies = value
    }

    @JvmName("ftyyprblswjgegcf")
    public suspend fun authorizationPolicies(
        vararg
        values: Output<SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs>,
    ) {
        this.authorizationPolicies = Output.all(values.asList())
    }

    /**
     * @param values List of authorization keys for a provisioning service.
     */
    @JvmName("dyauwyotjsjgumsy")
    public suspend
    fun authorizationPolicies(values: List<Output<SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs>>) {
        this.authorizationPolicies = Output.all(values)
    }

    /**
     * @param value Optional.
     * Indicates if the DPS instance has Data Residency enabled, removing the cross geo-pair disaster recovery.
     */
    @JvmName("alphpbunajyavlkh")
    public suspend fun enableDataResidency(`value`: Output<Boolean>) {
        this.enableDataResidency = value
    }

    /**
     * @param value List of IoT hubs associated with this provisioning service.
     */
    @JvmName("doeqldcugpfpqxpm")
    public suspend fun iotHubs(`value`: Output<List<IotHubDefinitionDescriptionArgs>>) {
        this.iotHubs = value
    }

    @JvmName("bluwiougucmmpikd")
    public suspend fun iotHubs(vararg values: Output<IotHubDefinitionDescriptionArgs>) {
        this.iotHubs = Output.all(values.asList())
    }

    /**
     * @param values List of IoT hubs associated with this provisioning service.
     */
    @JvmName("shwlonwmqfedvxue")
    public suspend fun iotHubs(values: List<Output<IotHubDefinitionDescriptionArgs>>) {
        this.iotHubs = Output.all(values)
    }

    /**
     * @param value The IP filter rules.
     */
    @JvmName("endourglmolljyuo")
    public suspend fun ipFilterRules(`value`: Output<List<TargetIpFilterRuleArgs>>) {
        this.ipFilterRules = value
    }

    @JvmName("mcrsbdwyfhbmsvpi")
    public suspend fun ipFilterRules(vararg values: Output<TargetIpFilterRuleArgs>) {
        this.ipFilterRules = Output.all(values.asList())
    }

    /**
     * @param values The IP filter rules.
     */
    @JvmName("jbfxxirerstyeahm")
    public suspend fun ipFilterRules(values: List<Output<TargetIpFilterRuleArgs>>) {
        this.ipFilterRules = Output.all(values)
    }

    /**
     * @param value Portal endpoint to enable CORS for this provisioning service.
     */
    @JvmName("cwfakgljcvfqgkrm")
    public suspend fun portalOperationsHostName(`value`: Output<String>) {
        this.portalOperationsHostName = value
    }

    /**
     * @param value Private endpoint connections created on this IotHub
     */
    @JvmName("xxsrwfdttkhvpllw")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("fghqbevwqipnobra")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<PrivateEndpointConnectionArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values Private endpoint connections created on this IotHub
     */
    @JvmName("wnjbeyqiqgsfkkvw")
    public suspend
    fun privateEndpointConnections(values: List<Output<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value The ARM provisioning state of the provisioning service.
     */
    @JvmName("xihxskjxaojarhjj")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("hfglnsatpyfkddlh")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Current state of the provisioning service.
     */
    @JvmName("qvmtvnolnhriegqb")
    public suspend fun state(`value`: Output<Either<String, State>>) {
        this.state = value
    }

    /**
     * @param value Allocation policy to be used by this provisioning service.
     */
    @JvmName("msuaqktvdqrsljfu")
    public suspend fun allocationPolicy(`value`: Either<String, AllocationPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationPolicy = mapped
    }

    /**
     * @param value Allocation policy to be used by this provisioning service.
     */
    @JvmName("wwuhswajgjbddyou")
    public fun allocationPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllocationPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationPolicy = mapped
    }

    /**
     * @param value Allocation policy to be used by this provisioning service.
     */
    @JvmName("hyucqbcrivgyhbib")
    public fun allocationPolicy(`value`: AllocationPolicy) {
        val toBeMapped = Either.ofRight<String, AllocationPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationPolicy = mapped
    }

    /**
     * @param value List of authorization keys for a provisioning service.
     */
    @JvmName("oydymjjctqbiveqd")
    public suspend
    fun authorizationPolicies(`value`: List<SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationPolicies = mapped
    }

    /**
     * @param argument List of authorization keys for a provisioning service.
     */
    @JvmName("rwhrosiohrqipglo")
    public suspend
    fun authorizationPolicies(argument: List<suspend SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizationPolicies = mapped
    }

    /**
     * @param argument List of authorization keys for a provisioning service.
     */
    @JvmName("rlqncbjpslmsyken")
    public suspend fun authorizationPolicies(
        vararg
        argument: suspend SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizationPolicies = mapped
    }

    /**
     * @param argument List of authorization keys for a provisioning service.
     */
    @JvmName("efifjehleoserglf")
    public suspend
    fun authorizationPolicies(argument: suspend SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.authorizationPolicies = mapped
    }

    /**
     * @param values List of authorization keys for a provisioning service.
     */
    @JvmName("ogwvtqiywmqangvk")
    public suspend fun authorizationPolicies(
        vararg
        values: SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationPolicies = mapped
    }

    /**
     * @param value Optional.
     * Indicates if the DPS instance has Data Residency enabled, removing the cross geo-pair disaster recovery.
     */
    @JvmName("mqoupmqdrrptfcbh")
    public suspend fun enableDataResidency(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDataResidency = mapped
    }

    /**
     * @param value List of IoT hubs associated with this provisioning service.
     */
    @JvmName("ywutldbmexejkgvv")
    public suspend fun iotHubs(`value`: List<IotHubDefinitionDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotHubs = mapped
    }

    /**
     * @param argument List of IoT hubs associated with this provisioning service.
     */
    @JvmName("fftnnpfaaytebrvv")
    public suspend
    fun iotHubs(argument: List<suspend IotHubDefinitionDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IotHubDefinitionDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotHubs = mapped
    }

    /**
     * @param argument List of IoT hubs associated with this provisioning service.
     */
    @JvmName("alaouittvrlxkxwm")
    public suspend fun iotHubs(
        vararg
        argument: suspend IotHubDefinitionDescriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IotHubDefinitionDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotHubs = mapped
    }

    /**
     * @param argument List of IoT hubs associated with this provisioning service.
     */
    @JvmName("xsvsyidukacguuyr")
    public suspend fun iotHubs(argument: suspend IotHubDefinitionDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IotHubDefinitionDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.iotHubs = mapped
    }

    /**
     * @param values List of IoT hubs associated with this provisioning service.
     */
    @JvmName("ilfvmwnsvyatlpkt")
    public suspend fun iotHubs(vararg values: IotHubDefinitionDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iotHubs = mapped
    }

    /**
     * @param value The IP filter rules.
     */
    @JvmName("ctkohelonvdguxrk")
    public suspend fun ipFilterRules(`value`: List<TargetIpFilterRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipFilterRules = mapped
    }

    /**
     * @param argument The IP filter rules.
     */
    @JvmName("leqiwvgmyxctwiqw")
    public suspend
    fun ipFilterRules(argument: List<suspend TargetIpFilterRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetIpFilterRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipFilterRules = mapped
    }

    /**
     * @param argument The IP filter rules.
     */
    @JvmName("hjtgwvaafcksqyyc")
    public suspend fun ipFilterRules(
        vararg
        argument: suspend TargetIpFilterRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TargetIpFilterRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipFilterRules = mapped
    }

    /**
     * @param argument The IP filter rules.
     */
    @JvmName("ympouoklqegfexss")
    public suspend fun ipFilterRules(argument: suspend TargetIpFilterRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TargetIpFilterRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipFilterRules = mapped
    }

    /**
     * @param values The IP filter rules.
     */
    @JvmName("jrhniconrbmvdosd")
    public suspend fun ipFilterRules(vararg values: TargetIpFilterRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipFilterRules = mapped
    }

    /**
     * @param value Portal endpoint to enable CORS for this provisioning service.
     */
    @JvmName("tcixkkfuliwxfqct")
    public suspend fun portalOperationsHostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portalOperationsHostName = mapped
    }

    /**
     * @param value Private endpoint connections created on this IotHub
     */
    @JvmName("ecfmqhvrcdscyipp")
    public suspend fun privateEndpointConnections(`value`: List<PrivateEndpointConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections created on this IotHub
     */
    @JvmName("ulmcjqddxenhmgda")
    public suspend
    fun privateEndpointConnections(argument: List<suspend PrivateEndpointConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections created on this IotHub
     */
    @JvmName("beljxksmrieyixca")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections created on this IotHub
     */
    @JvmName("kbvonwqxkburuomo")
    public suspend
    fun privateEndpointConnections(argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values Private endpoint connections created on this IotHub
     */
    @JvmName("xyopphbjnbfvlfye")
    public suspend fun privateEndpointConnections(vararg values: PrivateEndpointConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value The ARM provisioning state of the provisioning service.
     */
    @JvmName("vmwadkfdhlqurhxm")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("xavotcelgarsjfim")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("pkltuujgmvbnipun")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("uyxaxfnbqvwxdglj")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Current state of the provisioning service.
     */
    @JvmName("aclwhwsdejgtupif")
    public suspend fun state(`value`: Either<String, State>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Current state of the provisioning service.
     */
    @JvmName("kdysqnotlbacspgi")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Current state of the provisioning service.
     */
    @JvmName("lfwxbnlnbmebwdcc")
    public fun state(`value`: State) {
        val toBeMapped = Either.ofRight<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): IotDpsPropertiesDescriptionArgs = IotDpsPropertiesDescriptionArgs(
        allocationPolicy = allocationPolicy,
        authorizationPolicies = authorizationPolicies,
        enableDataResidency = enableDataResidency,
        iotHubs = iotHubs,
        ipFilterRules = ipFilterRules,
        portalOperationsHostName = portalOperationsHostName,
        privateEndpointConnections = privateEndpointConnections,
        provisioningState = provisioningState,
        publicNetworkAccess = publicNetworkAccess,
        state = state,
    )
}
