@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.IotHubPropertiesDeviceStreamsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The device streams properties of iothub.
 * @property streamingEndpoints List of Device Streams Endpoints.
 */
public data class IotHubPropertiesDeviceStreamsArgs(
    public val streamingEndpoints: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.IotHubPropertiesDeviceStreamsArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.IotHubPropertiesDeviceStreamsArgs =
        com.pulumi.azurenative.devices.inputs.IotHubPropertiesDeviceStreamsArgs.builder()
            .streamingEndpoints(
                streamingEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [IotHubPropertiesDeviceStreamsArgs].
 */
@PulumiTagMarker
public class IotHubPropertiesDeviceStreamsArgsBuilder internal constructor() {
    private var streamingEndpoints: Output<List<String>>? = null

    /**
     * @param value List of Device Streams Endpoints.
     */
    @JvmName("qkawbprpsydabllr")
    public suspend fun streamingEndpoints(`value`: Output<List<String>>) {
        this.streamingEndpoints = value
    }

    @JvmName("xonamacvclrrxlld")
    public suspend fun streamingEndpoints(vararg values: Output<String>) {
        this.streamingEndpoints = Output.all(values.asList())
    }

    /**
     * @param values List of Device Streams Endpoints.
     */
    @JvmName("yafvddsaanskmwat")
    public suspend fun streamingEndpoints(values: List<Output<String>>) {
        this.streamingEndpoints = Output.all(values)
    }

    /**
     * @param value List of Device Streams Endpoints.
     */
    @JvmName("olenjoxtfiksscwr")
    public suspend fun streamingEndpoints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingEndpoints = mapped
    }

    /**
     * @param values List of Device Streams Endpoints.
     */
    @JvmName("yxymcwwtqqafdpmn")
    public suspend fun streamingEndpoints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamingEndpoints = mapped
    }

    internal fun build(): IotHubPropertiesDeviceStreamsArgs = IotHubPropertiesDeviceStreamsArgs(
        streamingEndpoints = streamingEndpoints,
    )
}
