@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.IotHubSkuInfoArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.IotHubSku
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about the SKU of the IoT hub.
 * @property capacity The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
 * @property name The name of the SKU.
 */
public data class IotHubSkuInfoArgs(
    public val capacity: Output<Double>? = null,
    public val name: Output<Either<String, IotHubSku>>,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.IotHubSkuInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.IotHubSkuInfoArgs =
        com.pulumi.azurenative.devices.inputs.IotHubSkuInfoArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IotHubSkuInfoArgs].
 */
@PulumiTagMarker
public class IotHubSkuInfoArgsBuilder internal constructor() {
    private var capacity: Output<Double>? = null

    private var name: Output<Either<String, IotHubSku>>? = null

    /**
     * @param value The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
     */
    @JvmName("vwvxaxqtuhfgxiqu")
    public suspend fun capacity(`value`: Output<Double>) {
        this.capacity = value
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("ktrwwnvjhnkdbykl")
    public suspend fun name(`value`: Output<Either<String, IotHubSku>>) {
        this.name = value
    }

    /**
     * @param value The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
     */
    @JvmName("hjuittykmvdfwgqu")
    public suspend fun capacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("atfokldoxcmblsov")
    public suspend fun name(`value`: Either<String, IotHubSku>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("bmlfdshvklplbctx")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IotHubSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("iugkekbaoyjpfrhu")
    public fun name(`value`: IotHubSku) {
        val toBeMapped = Either.ofRight<String, IotHubSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): IotHubSkuInfoArgs = IotHubSkuInfoArgs(
        capacity = capacity,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
