@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.PrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.PrivateLinkServiceConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The current state of a private endpoint connection
 * @property actionsRequired Actions required for a private endpoint connection
 * @property description The description for the current state of a private endpoint connection
 * @property status The status of a private endpoint connection
 */
public data class PrivateLinkServiceConnectionStateArgs(
    public val actionsRequired: Output<String>? = null,
    public val description: Output<String>,
    public val status: Output<Either<String, PrivateLinkServiceConnectionStatus>>,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.PrivateLinkServiceConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.PrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.devices.inputs.PrivateLinkServiceConnectionStateArgs.builder()
            .actionsRequired(actionsRequired?.applyValue({ args0 -> args0 }))
            .description(description.applyValue({ args0 -> args0 }))
            .status(
                status.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<Either<String, PrivateLinkServiceConnectionStatus>>? = null

    /**
     * @param value Actions required for a private endpoint connection
     */
    @JvmName("lhbggelrowajrdkl")
    public suspend fun actionsRequired(`value`: Output<String>) {
        this.actionsRequired = value
    }

    /**
     * @param value The description for the current state of a private endpoint connection
     */
    @JvmName("drguanexfagscsch")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The status of a private endpoint connection
     */
    @JvmName("cwbsuquiynwvjrdi")
    public suspend fun status(`value`: Output<Either<String, PrivateLinkServiceConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value Actions required for a private endpoint connection
     */
    @JvmName("ydoefmgoihlakuge")
    public suspend fun actionsRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value The description for the current state of a private endpoint connection
     */
    @JvmName("tfynxbpbhjggvcqa")
    public suspend fun description(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The status of a private endpoint connection
     */
    @JvmName("jbyngytltdvdxwkh")
    public suspend fun status(`value`: Either<String, PrivateLinkServiceConnectionStatus>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of a private endpoint connection
     */
    @JvmName("sdvhgvkeremujink")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateLinkServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of a private endpoint connection
     */
    @JvmName("qaifelalpbhdgnej")
    public fun status(`value`: PrivateLinkServiceConnectionStatus) {
        val toBeMapped = Either.ofRight<String, PrivateLinkServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStateArgs =
        PrivateLinkServiceConnectionStateArgs(
            actionsRequired = actionsRequired,
            description = description ?: throw PulumiNullFieldException("description"),
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
