@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.AccessRightsDescription
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of the shared access key.
 * @property keyName Name of the key.
 * @property primaryKey Primary SAS key value.
 * @property rights Rights that this key has.
 * @property secondaryKey Secondary SAS key value.
 */
public data class SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs(
    public val keyName: Output<String>,
    public val primaryKey: Output<String>? = null,
    public val rights: Output<Either<String, AccessRightsDescription>>,
    public val secondaryKey: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.devices.inputs.SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs> {
    override fun toJava():
        com.pulumi.azurenative.devices.inputs.SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs =
        com.pulumi.azurenative.devices.inputs.SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs.builder()
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .primaryKey(primaryKey?.applyValue({ args0 -> args0 }))
            .rights(
                rights.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .secondaryKey(secondaryKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs].
 */
@PulumiTagMarker
public class SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgsBuilder internal
constructor() {
    private var keyName: Output<String>? = null

    private var primaryKey: Output<String>? = null

    private var rights: Output<Either<String, AccessRightsDescription>>? = null

    private var secondaryKey: Output<String>? = null

    /**
     * @param value Name of the key.
     */
    @JvmName("ertgjftuvimoifpi")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value Primary SAS key value.
     */
    @JvmName("ulctcapsukaijnrc")
    public suspend fun primaryKey(`value`: Output<String>) {
        this.primaryKey = value
    }

    /**
     * @param value Rights that this key has.
     */
    @JvmName("xqrmcumadwimktcu")
    public suspend fun rights(`value`: Output<Either<String, AccessRightsDescription>>) {
        this.rights = value
    }

    /**
     * @param value Secondary SAS key value.
     */
    @JvmName("srewtduhgxnuhtid")
    public suspend fun secondaryKey(`value`: Output<String>) {
        this.secondaryKey = value
    }

    /**
     * @param value Name of the key.
     */
    @JvmName("xbuhhyejhpyhfniw")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value Primary SAS key value.
     */
    @JvmName("qhsmitybscscqkup")
    public suspend fun primaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKey = mapped
    }

    /**
     * @param value Rights that this key has.
     */
    @JvmName("prdkqoqmjkwackfy")
    public suspend fun rights(`value`: Either<String, AccessRightsDescription>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param value Rights that this key has.
     */
    @JvmName("bkuaiscnosebnfph")
    public fun rights(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessRightsDescription>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param value Rights that this key has.
     */
    @JvmName("xtlvawfignujires")
    public fun rights(`value`: AccessRightsDescription) {
        val toBeMapped = Either.ofRight<String, AccessRightsDescription>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param value Secondary SAS key value.
     */
    @JvmName("saohspuoiwyiuedj")
    public suspend fun secondaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryKey = mapped
    }

    internal fun build(): SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs =
        SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionArgs(
            keyName = keyName ?: throw PulumiNullFieldException("keyName"),
            primaryKey = primaryKey,
            rights = rights ?: throw PulumiNullFieldException("rights"),
            secondaryKey = secondaryKey,
        )
}
