@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The list of shared access policies with a next link.
 * @property nextLink The next link.
 * @property value The list of shared access policies.
 */
public data class ListIotHubResourceKeysResult(
    public val nextLink: String,
    public val `value`: List<SharedAccessSignatureAuthorizationRuleResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.ListIotHubResourceKeysResult):
            ListIotHubResourceKeysResult = ListIotHubResourceKeysResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.SharedAccessSignatureAuthorizationRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
