@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The current state of a private endpoint connection
 * @property actionsRequired Actions required for a private endpoint connection
 * @property description The description for the current state of a private endpoint connection
 * @property status The status of a private endpoint connection
 */
public data class PrivateLinkServiceConnectionStateResponse(
    public val actionsRequired: String? = null,
    public val description: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.PrivateLinkServiceConnectionStateResponse):
            PrivateLinkServiceConnectionStateResponse = PrivateLinkServiceConnectionStateResponse(
            actionsRequired = javaType.actionsRequired().map({ args0 -> args0 }).orElse(null),
            description = javaType.description(),
            status = javaType.status(),
        )
    }
}
