@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties related to a cosmos DB sql collection endpoint.
 * @property authenticationType Method used to authenticate against the cosmos DB sql collection endpoint
 * @property collectionName The name of the cosmos DB sql collection in the cosmos DB database.
 * @property databaseName The name of the cosmos DB database in the cosmos DB account.
 * @property endpointUri The url of the cosmos DB account. It must include the protocol https://
 * @property id Id of the cosmos DB sql collection endpoint
 * @property identity Managed identity properties of routing cosmos DB collection endpoint.
 * @property name The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
 * @property partitionKeyName The name of the partition key associated with this cosmos DB sql collection if one exists. This is an optional parameter.
 * @property partitionKeyTemplate The template for generating a synthetic partition key value for use with this cosmos DB sql collection. The template must include at least one of the following placeholders: {iothub}, {deviceid}, {DD}, {MM}, and {YYYY}. Any one placeholder may be specified at most once, but order and non-placeholder components are arbitrary. This parameter is only required if PartitionKeyName is specified.
 * @property primaryKey The primary key of the cosmos DB account.
 * @property resourceGroup The name of the resource group of the cosmos DB account.
 * @property secondaryKey The secondary key of the cosmos DB account.
 * @property subscriptionId The subscription identifier of the cosmos DB account.
 */
public data class RoutingCosmosDBSqlApiPropertiesResponse(
    public val authenticationType: String? = null,
    public val collectionName: String,
    public val databaseName: String,
    public val endpointUri: String,
    public val id: String? = null,
    public val identity: ManagedIdentityResponse? = null,
    public val name: String,
    public val partitionKeyName: String? = null,
    public val partitionKeyTemplate: String? = null,
    public val primaryKey: String? = null,
    public val resourceGroup: String? = null,
    public val secondaryKey: String? = null,
    public val subscriptionId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.RoutingCosmosDBSqlApiPropertiesResponse):
            RoutingCosmosDBSqlApiPropertiesResponse = RoutingCosmosDBSqlApiPropertiesResponse(
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            collectionName = javaType.collectionName(),
            databaseName = javaType.databaseName(),
            endpointUri = javaType.endpointUri(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            partitionKeyName = javaType.partitionKeyName().map({ args0 -> args0 }).orElse(null),
            partitionKeyTemplate = javaType.partitionKeyTemplate().map({ args0 -> args0 }).orElse(null),
            primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
