@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.inputs

import com.pulumi.azurenative.deviceupdate.inputs.GroupConnectivityInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Group connectivity details.
 * @property customerVisibleFqdns List of customer visible FQDNs.
 * @property privateLinkServiceArmRegion PrivateLinkService ARM region.
 * @property redirectMapId Redirect map ID.
 */
public data class GroupConnectivityInformationArgs(
    public val customerVisibleFqdns: Output<List<String>>? = null,
    public val privateLinkServiceArmRegion: Output<String>? = null,
    public val redirectMapId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceupdate.inputs.GroupConnectivityInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceupdate.inputs.GroupConnectivityInformationArgs =
        com.pulumi.azurenative.deviceupdate.inputs.GroupConnectivityInformationArgs.builder()
            .customerVisibleFqdns(customerVisibleFqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateLinkServiceArmRegion(privateLinkServiceArmRegion?.applyValue({ args0 -> args0 }))
            .redirectMapId(redirectMapId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupConnectivityInformationArgs].
 */
@PulumiTagMarker
public class GroupConnectivityInformationArgsBuilder internal constructor() {
    private var customerVisibleFqdns: Output<List<String>>? = null

    private var privateLinkServiceArmRegion: Output<String>? = null

    private var redirectMapId: Output<String>? = null

    /**
     * @param value List of customer visible FQDNs.
     */
    @JvmName("aboexrrjluaawsvd")
    public suspend fun customerVisibleFqdns(`value`: Output<List<String>>) {
        this.customerVisibleFqdns = value
    }

    @JvmName("jydubkqjwqmtglgd")
    public suspend fun customerVisibleFqdns(vararg values: Output<String>) {
        this.customerVisibleFqdns = Output.all(values.asList())
    }

    /**
     * @param values List of customer visible FQDNs.
     */
    @JvmName("abshdbkxmibbkxpg")
    public suspend fun customerVisibleFqdns(values: List<Output<String>>) {
        this.customerVisibleFqdns = Output.all(values)
    }

    /**
     * @param value PrivateLinkService ARM region.
     */
    @JvmName("srkrhytjtfojfmwc")
    public suspend fun privateLinkServiceArmRegion(`value`: Output<String>) {
        this.privateLinkServiceArmRegion = value
    }

    /**
     * @param value Redirect map ID.
     */
    @JvmName("wklvvuonwabfhwkt")
    public suspend fun redirectMapId(`value`: Output<String>) {
        this.redirectMapId = value
    }

    /**
     * @param value List of customer visible FQDNs.
     */
    @JvmName("hcsrdfesfjaiveso")
    public suspend fun customerVisibleFqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerVisibleFqdns = mapped
    }

    /**
     * @param values List of customer visible FQDNs.
     */
    @JvmName("ettkgthxjccepltn")
    public suspend fun customerVisibleFqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerVisibleFqdns = mapped
    }

    /**
     * @param value PrivateLinkService ARM region.
     */
    @JvmName("mlsntbdnnguyebcy")
    public suspend fun privateLinkServiceArmRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceArmRegion = mapped
    }

    /**
     * @param value Redirect map ID.
     */
    @JvmName("pttvkibvccfkvyec")
    public suspend fun redirectMapId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectMapId = mapped
    }

    internal fun build(): GroupConnectivityInformationArgs = GroupConnectivityInformationArgs(
        customerVisibleFqdns = customerVisibleFqdns,
        privateLinkServiceArmRegion = privateLinkServiceArmRegion,
        redirectMapId = redirectMapId,
    )
}
