@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.inputs

import com.pulumi.azurenative.deviceupdate.inputs.RemotePrivateEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Remote private endpoint details.
 * @property id Remote endpoint resource ID.
 * @property immutableResourceId Original resource ID needed by Microsoft.Network.
 * @property immutableSubscriptionId Original subscription ID needed by Microsoft.Network.
 * @property location ARM location of the remote private endpoint.
 * @property manualPrivateLinkServiceConnections List of private link service connections that need manual approval.
 * @property privateLinkServiceConnections List of automatically approved private link service connections.
 * @property privateLinkServiceProxies List of private link service proxies.
 * @property vnetTrafficTag Virtual network traffic tag.
 */
public data class RemotePrivateEndpointArgs(
    public val id: Output<String>? = null,
    public val immutableResourceId: Output<String>? = null,
    public val immutableSubscriptionId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val manualPrivateLinkServiceConnections: Output<List<PrivateLinkServiceConnectionArgs>>? =
        null,
    public val privateLinkServiceConnections: Output<List<PrivateLinkServiceConnectionArgs>>? = null,
    public val privateLinkServiceProxies: Output<List<PrivateLinkServiceProxyArgs>>? = null,
    public val vnetTrafficTag: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceupdate.inputs.RemotePrivateEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceupdate.inputs.RemotePrivateEndpointArgs =
        com.pulumi.azurenative.deviceupdate.inputs.RemotePrivateEndpointArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .immutableResourceId(immutableResourceId?.applyValue({ args0 -> args0 }))
            .immutableSubscriptionId(immutableSubscriptionId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .manualPrivateLinkServiceConnections(
                manualPrivateLinkServiceConnections?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateLinkServiceConnections(
                privateLinkServiceConnections?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateLinkServiceProxies(
                privateLinkServiceProxies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vnetTrafficTag(vnetTrafficTag?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RemotePrivateEndpointArgs].
 */
@PulumiTagMarker
public class RemotePrivateEndpointArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var immutableResourceId: Output<String>? = null

    private var immutableSubscriptionId: Output<String>? = null

    private var location: Output<String>? = null

    private var manualPrivateLinkServiceConnections: Output<List<PrivateLinkServiceConnectionArgs>>? =
        null

    private var privateLinkServiceConnections: Output<List<PrivateLinkServiceConnectionArgs>>? = null

    private var privateLinkServiceProxies: Output<List<PrivateLinkServiceProxyArgs>>? = null

    private var vnetTrafficTag: Output<String>? = null

    /**
     * @param value Remote endpoint resource ID.
     */
    @JvmName("yjqajcdncuhnrkxk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Original resource ID needed by Microsoft.Network.
     */
    @JvmName("svfixiiflwmgyjci")
    public suspend fun immutableResourceId(`value`: Output<String>) {
        this.immutableResourceId = value
    }

    /**
     * @param value Original subscription ID needed by Microsoft.Network.
     */
    @JvmName("vugyicxqibnbjlwc")
    public suspend fun immutableSubscriptionId(`value`: Output<String>) {
        this.immutableSubscriptionId = value
    }

    /**
     * @param value ARM location of the remote private endpoint.
     */
    @JvmName("xfwtkkbcgcwawssn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value List of private link service connections that need manual approval.
     */
    @JvmName("ffaspuqkgpqimpri")
    public suspend
    fun manualPrivateLinkServiceConnections(`value`: Output<List<PrivateLinkServiceConnectionArgs>>) {
        this.manualPrivateLinkServiceConnections = value
    }

    @JvmName("opmvppsemlfdtwak")
    public suspend fun manualPrivateLinkServiceConnections(
        vararg
        values: Output<PrivateLinkServiceConnectionArgs>,
    ) {
        this.manualPrivateLinkServiceConnections = Output.all(values.asList())
    }

    /**
     * @param values List of private link service connections that need manual approval.
     */
    @JvmName("erjuwclxhkbbptsq")
    public suspend
    fun manualPrivateLinkServiceConnections(values: List<Output<PrivateLinkServiceConnectionArgs>>) {
        this.manualPrivateLinkServiceConnections = Output.all(values)
    }

    /**
     * @param value List of automatically approved private link service connections.
     */
    @JvmName("cilgsskefxirmych")
    public suspend
    fun privateLinkServiceConnections(`value`: Output<List<PrivateLinkServiceConnectionArgs>>) {
        this.privateLinkServiceConnections = value
    }

    @JvmName("vbphjgsudkuiobmi")
    public suspend fun privateLinkServiceConnections(
        vararg
        values: Output<PrivateLinkServiceConnectionArgs>,
    ) {
        this.privateLinkServiceConnections = Output.all(values.asList())
    }

    /**
     * @param values List of automatically approved private link service connections.
     */
    @JvmName("kqucqjcvawemykiy")
    public suspend
    fun privateLinkServiceConnections(values: List<Output<PrivateLinkServiceConnectionArgs>>) {
        this.privateLinkServiceConnections = Output.all(values)
    }

    /**
     * @param value List of private link service proxies.
     */
    @JvmName("uumydohhksngncjh")
    public suspend fun privateLinkServiceProxies(`value`: Output<List<PrivateLinkServiceProxyArgs>>) {
        this.privateLinkServiceProxies = value
    }

    @JvmName("xyatehhokvvqnbcm")
    public suspend fun privateLinkServiceProxies(vararg values: Output<PrivateLinkServiceProxyArgs>) {
        this.privateLinkServiceProxies = Output.all(values.asList())
    }

    /**
     * @param values List of private link service proxies.
     */
    @JvmName("tbhlmgucvwidltqp")
    public suspend fun privateLinkServiceProxies(values: List<Output<PrivateLinkServiceProxyArgs>>) {
        this.privateLinkServiceProxies = Output.all(values)
    }

    /**
     * @param value Virtual network traffic tag.
     */
    @JvmName("rppfulaqsgjcfvxs")
    public suspend fun vnetTrafficTag(`value`: Output<String>) {
        this.vnetTrafficTag = value
    }

    /**
     * @param value Remote endpoint resource ID.
     */
    @JvmName("cdmjrwmfepjbscgm")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Original resource ID needed by Microsoft.Network.
     */
    @JvmName("iflpebwhtwxuejib")
    public suspend fun immutableResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immutableResourceId = mapped
    }

    /**
     * @param value Original subscription ID needed by Microsoft.Network.
     */
    @JvmName("xflbetktahjcrdwa")
    public suspend fun immutableSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immutableSubscriptionId = mapped
    }

    /**
     * @param value ARM location of the remote private endpoint.
     */
    @JvmName("rxjruexrjqkcgfdy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value List of private link service connections that need manual approval.
     */
    @JvmName("vfggoasglmwvytvu")
    public suspend
    fun manualPrivateLinkServiceConnections(`value`: List<PrivateLinkServiceConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param argument List of private link service connections that need manual approval.
     */
    @JvmName("skwqassgtbcmbhir")
    public suspend
    fun manualPrivateLinkServiceConnections(argument: List<suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param argument List of private link service connections that need manual approval.
     */
    @JvmName("fhrhfjtfdihrxukp")
    public suspend fun manualPrivateLinkServiceConnections(
        vararg
        argument: suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param argument List of private link service connections that need manual approval.
     */
    @JvmName("galwfjgehrqbwlti")
    public suspend
    fun manualPrivateLinkServiceConnections(argument: suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param values List of private link service connections that need manual approval.
     */
    @JvmName("jpamfadpbacsxpvs")
    public suspend fun manualPrivateLinkServiceConnections(
        vararg
        values: PrivateLinkServiceConnectionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param value List of automatically approved private link service connections.
     */
    @JvmName("lhguyiynyxqkeqpy")
    public suspend
    fun privateLinkServiceConnections(`value`: List<PrivateLinkServiceConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnections = mapped
    }

    /**
     * @param argument List of automatically approved private link service connections.
     */
    @JvmName("nlffgvthpblumwei")
    public suspend
    fun privateLinkServiceConnections(argument: List<suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnections = mapped
    }

    /**
     * @param argument List of automatically approved private link service connections.
     */
    @JvmName("sqstyrjaskqfgoas")
    public suspend fun privateLinkServiceConnections(
        vararg
        argument: suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnections = mapped
    }

    /**
     * @param argument List of automatically approved private link service connections.
     */
    @JvmName("nmknlwxtwdiwdvnd")
    public suspend
    fun privateLinkServiceConnections(argument: suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnections = mapped
    }

    /**
     * @param values List of automatically approved private link service connections.
     */
    @JvmName("uturagkyfbhkhdjj")
    public suspend fun privateLinkServiceConnections(
        vararg
        values: PrivateLinkServiceConnectionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceConnections = mapped
    }

    /**
     * @param value List of private link service proxies.
     */
    @JvmName("trwqrfrforivshot")
    public suspend fun privateLinkServiceProxies(`value`: List<PrivateLinkServiceProxyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceProxies = mapped
    }

    /**
     * @param argument List of private link service proxies.
     */
    @JvmName("fgadpnvskckbbsfg")
    public suspend
    fun privateLinkServiceProxies(argument: List<suspend PrivateLinkServiceProxyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceProxyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkServiceProxies = mapped
    }

    /**
     * @param argument List of private link service proxies.
     */
    @JvmName("prpclyqqgqupahrv")
    public suspend fun privateLinkServiceProxies(
        vararg
        argument: suspend PrivateLinkServiceProxyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceProxyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkServiceProxies = mapped
    }

    /**
     * @param argument List of private link service proxies.
     */
    @JvmName("quiiggbhjcjqiyqy")
    public suspend
    fun privateLinkServiceProxies(argument: suspend PrivateLinkServiceProxyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkServiceProxyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateLinkServiceProxies = mapped
    }

    /**
     * @param values List of private link service proxies.
     */
    @JvmName("cuweqhivgbuijgho")
    public suspend fun privateLinkServiceProxies(vararg values: PrivateLinkServiceProxyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceProxies = mapped
    }

    /**
     * @param value Virtual network traffic tag.
     */
    @JvmName("dsxhlfhpqfsyxwjf")
    public suspend fun vnetTrafficTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetTrafficTag = mapped
    }

    internal fun build(): RemotePrivateEndpointArgs = RemotePrivateEndpointArgs(
        id = id,
        immutableResourceId = immutableResourceId,
        immutableSubscriptionId = immutableSubscriptionId,
        location = location,
        manualPrivateLinkServiceConnections = manualPrivateLinkServiceConnections,
        privateLinkServiceConnections = privateLinkServiceConnections,
        privateLinkServiceProxies = privateLinkServiceProxies,
        vnetTrafficTag = vnetTrafficTag,
    )
}
