@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Private link service proxy details.
 * @property groupConnectivityInformation Group connectivity information.
 * @property id NRP resource ID.
 * @property remotePrivateEndpointConnection Remote private endpoint connection details.
 * @property remotePrivateLinkServiceConnectionState Remote private link service connection state
 */
public data class PrivateLinkServiceProxyResponse(
    public val groupConnectivityInformation: List<GroupConnectivityInformationResponse>? = null,
    public val id: String? = null,
    public val remotePrivateEndpointConnection:
    PrivateLinkServiceProxyResponseRemotePrivateEndpointConnection? = null,
    public val remotePrivateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceupdate.outputs.PrivateLinkServiceProxyResponse):
            PrivateLinkServiceProxyResponse = PrivateLinkServiceProxyResponse(
            groupConnectivityInformation = javaType.groupConnectivityInformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceupdate.kotlin.outputs.GroupConnectivityInformationResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            remotePrivateEndpointConnection = javaType.remotePrivateEndpointConnection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceupdate.kotlin.outputs.PrivateLinkServiceProxyResponseRemotePrivateEndpointConnection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            remotePrivateLinkServiceConnectionState = javaType.remotePrivateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceupdate.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
