@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin

import com.pulumi.azurenative.devopsinfrastructure.DevopsinfrastructureFunctions.getPoolPlain
import com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs.GetPoolPlainArgs
import com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs.GetPoolPlainArgsBuilder
import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.GetPoolResult
import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.GetPoolResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object DevopsinfrastructureFunctions {
    /**
     * Get a Pool
     * Azure REST API version: 2023-10-30-preview.
     * @param argument null
     * @return Concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getPool(argument: GetPoolPlainArgs): GetPoolResult =
        toKotlin(getPoolPlain(argument.toJava()).await())

    /**
     * @see [getPool].
     * @param poolName Name of the pool. It needs to be globally unique.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getPool(poolName: String, resourceGroupName: String): GetPoolResult {
        val argument = GetPoolPlainArgs(
            poolName = poolName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devopsinfrastructure&#46;kotlin&#46;inputs&#46;GetPoolPlainArgs].
     * @return Concrete tracked resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getPool(argument: suspend GetPoolPlainArgsBuilder.() -> Unit): GetPoolResult {
        val builder = GetPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getPoolPlain(builtArgument.toJava()).await())
    }
}
