@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs

import com.pulumi.azurenative.devopsinfrastructure.inputs.AzureDevOpsOrganizationProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure DevOps organization profile
 * @property kind Discriminator property for OrganizationProfile.
 * Expected value is 'AzureDevOps'.
 * @property organizations The list of Azure DevOps organizations the pool should be present in.
 */
public data class AzureDevOpsOrganizationProfileArgs(
    public val kind: Output<String>,
    public val organizations: Output<List<OrganizationArgs>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.inputs.AzureDevOpsOrganizationProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.devopsinfrastructure.inputs.AzureDevOpsOrganizationProfileArgs =
        com.pulumi.azurenative.devopsinfrastructure.inputs.AzureDevOpsOrganizationProfileArgs.builder()
            .kind(kind.applyValue({ args0 -> args0 }))
            .organizations(
                organizations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureDevOpsOrganizationProfileArgs].
 */
@PulumiTagMarker
public class AzureDevOpsOrganizationProfileArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var organizations: Output<List<OrganizationArgs>>? = null

    /**
     * @param value Discriminator property for OrganizationProfile.
     * Expected value is 'AzureDevOps'.
     */
    @JvmName("thdslqgiddptxylb")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The list of Azure DevOps organizations the pool should be present in.
     */
    @JvmName("hgqkuijftbwmhish")
    public suspend fun organizations(`value`: Output<List<OrganizationArgs>>) {
        this.organizations = value
    }

    @JvmName("qxhxciavirmldpqr")
    public suspend fun organizations(vararg values: Output<OrganizationArgs>) {
        this.organizations = Output.all(values.asList())
    }

    /**
     * @param values The list of Azure DevOps organizations the pool should be present in.
     */
    @JvmName("issxkymypuywyalk")
    public suspend fun organizations(values: List<Output<OrganizationArgs>>) {
        this.organizations = Output.all(values)
    }

    /**
     * @param value Discriminator property for OrganizationProfile.
     * Expected value is 'AzureDevOps'.
     */
    @JvmName("mnvomxvwdxggvtnj")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The list of Azure DevOps organizations the pool should be present in.
     */
    @JvmName("erjriwfbdqsrdkth")
    public suspend fun organizations(`value`: List<OrganizationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizations = mapped
    }

    /**
     * @param argument The list of Azure DevOps organizations the pool should be present in.
     */
    @JvmName("mvuqbbwuvedfdvay")
    public suspend fun organizations(argument: List<suspend OrganizationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OrganizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.organizations = mapped
    }

    /**
     * @param argument The list of Azure DevOps organizations the pool should be present in.
     */
    @JvmName("agykfnaomckgvveu")
    public suspend fun organizations(vararg argument: suspend OrganizationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OrganizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.organizations = mapped
    }

    /**
     * @param argument The list of Azure DevOps organizations the pool should be present in.
     */
    @JvmName("qokqrvkjgrsixowt")
    public suspend fun organizations(argument: suspend OrganizationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OrganizationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.organizations = mapped
    }

    /**
     * @param values The list of Azure DevOps organizations the pool should be present in.
     */
    @JvmName("yytctdwesxfpbssb")
    public suspend fun organizations(vararg values: OrganizationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizations = mapped
    }

    internal fun build(): AzureDevOpsOrganizationProfileArgs = AzureDevOpsOrganizationProfileArgs(
        kind = kind ?: throw PulumiNullFieldException("kind"),
        organizations = organizations ?: throw PulumiNullFieldException("organizations"),
    )
}
