@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure DevOps organization profile
 * @property kind Discriminator property for OrganizationProfile.
 * Expected value is 'AzureDevOps'.
 * @property organizations The list of Azure DevOps organizations the pool should be present in.
 */
public data class AzureDevOpsOrganizationProfileResponse(
    public val kind: String,
    public val organizations: List<OrganizationResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.outputs.AzureDevOpsOrganizationProfileResponse):
            AzureDevOpsOrganizationProfileResponse = AzureDevOpsOrganizationProfileResponse(
            kind = javaType.kind(),
            organizations = javaType.organizations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.OrganizationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
