@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devspaces.kotlin.inputs

import com.pulumi.azurenative.devspaces.inputs.GetControllerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the resource.
 * @property resourceGroupName Resource group to which the resource belongs.
 */
public data class GetControllerPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devspaces.inputs.GetControllerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devspaces.inputs.GetControllerPlainArgs =
        com.pulumi.azurenative.devspaces.inputs.GetControllerPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetControllerPlainArgs].
 */
@PulumiTagMarker
public class GetControllerPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the resource.
     */
    @JvmName("vvyduaffjbhorbps")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Resource group to which the resource belongs.
     */
    @JvmName("kmcvghlyoxhabufu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetControllerPlainArgs = GetControllerPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
