@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.FormulaPropertiesFromVmResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.LabVirtualMachineCreationParameterResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devtestlab.kotlin.outputs.FormulaPropertiesFromVmResponse.Companion.toKotlin as formulaPropertiesFromVmResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.LabVirtualMachineCreationParameterResponse.Companion.toKotlin as labVirtualMachineCreationParameterResponseToKotlin

/**
 * Builder for [Formula].
 */
@PulumiTagMarker
public class FormulaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FormulaArgs = FormulaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FormulaArgsBuilder.() -> Unit) {
        val builder = FormulaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Formula {
        val builtJavaResource = com.pulumi.azurenative.devtestlab.Formula(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Formula(builtJavaResource)
    }
}

/**
 * A formula for creating a VM, specifying an image base and other parameters
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Formulas_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var formula = new AzureNative.DevTestLab.Formula("formula", new()
 *     {
 *         Description = "Formula using a Linux base",
 *         FormulaContent = new AzureNative.DevTestLab.Inputs.LabVirtualMachineCreationParameterArgs
 *         {
 *             AllowClaim = false,
 *             Artifacts = new[]
 *             {
 *                 new AzureNative.DevTestLab.Inputs.ArtifactInstallPropertiesArgs
 *                 {
 *                     ArtifactId = "/artifactsources/{artifactSourceName}/artifacts/linux-install-nodejs",
 *                     Parameters = new[] {},
 *                 },
 *             },
 *             DisallowPublicIpAddress = true,
 *             GalleryImageReference = new AzureNative.DevTestLab.Inputs.GalleryImageReferenceArgs
 *             {
 *                 Offer = "0001-com-ubuntu-server-groovy",
 *                 OsType = "Linux",
 *                 Publisher = "canonical",
 *                 Sku = "20_10",
 *                 Version = "latest",
 *             },
 *             IsAuthenticationWithSshKey = false,
 *             LabSubnetName = "Dtl{labName}Subnet",
 *             LabVirtualNetworkId = "/virtualnetworks/dtl{labName}",
 *             Location = "{location}",
 *             NetworkInterface = new AzureNative.DevTestLab.Inputs.NetworkInterfacePropertiesArgs
 *             {
 *                 SharedPublicIpAddressConfiguration = new AzureNative.DevTestLab.Inputs.SharedPublicIpAddressConfigurationArgs
 *                 {
 *                     InboundNatRules = new[]
 *                     {
 *                         new AzureNative.DevTestLab.Inputs.InboundNatRuleArgs
 *                         {
 *                             BackendPort = 22,
 *                             TransportProtocol = "Tcp",
 *                         },
 *                     },
 *                 },
 *             },
 *             Notes = "Ubuntu Server 20.10",
 *             Size = "Standard_B1ms",
 *             StorageType = "Standard",
 *             UserName = "user",
 *         },
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "{formulaName}",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := devtestlab.NewFormula(ctx, "formula", &devtestlab.FormulaArgs{
 * Description: pulumi.String("Formula using a Linux base"),
 * FormulaContent: devtestlab.LabVirtualMachineCreationParameterResponse{
 * AllowClaim: pulumi.Bool(false),
 * Artifacts: devtestlab.ArtifactInstallPropertiesArray{
 * interface{}{
 * ArtifactId: pulumi.String("/artifactsources/{artifactSourceName}/artifacts/linux-install-nodejs"),
 * Parameters: devtestlab.ArtifactParameterPropertiesArray{
 * },
 * },
 * },
 * DisallowPublicIpAddress: pulumi.Bool(true),
 * GalleryImageReference: &devtestlab.GalleryImageReferenceArgs{
 * Offer: pulumi.String("0001-com-ubuntu-server-groovy"),
 * OsType: pulumi.String("Linux"),
 * Publisher: pulumi.String("canonical"),
 * Sku: pulumi.String("20_10"),
 * Version: pulumi.String("latest"),
 * },
 * IsAuthenticationWithSshKey: pulumi.Bool(false),
 * LabSubnetName: pulumi.String("Dtl{labName}Subnet"),
 * LabVirtualNetworkId: pulumi.String("/virtualnetworks/dtl{labName}"),
 * Location: pulumi.String("{location}"),
 * NetworkInterface: interface{}{
 * SharedPublicIpAddressConfiguration: interface{}{
 * InboundNatRules: devtestlab.InboundNatRuleArray{
 * &devtestlab.InboundNatRuleArgs{
 * BackendPort: pulumi.Int(22),
 * TransportProtocol: pulumi.String("Tcp"),
 * },
 * },
 * },
 * },
 * Notes: pulumi.String("Ubuntu Server 20.10"),
 * Size: pulumi.String("Standard_B1ms"),
 * StorageType: pulumi.String("Standard"),
 * UserName: pulumi.String("user"),
 * },
 * LabName: pulumi.String("{labName}"),
 * Location: pulumi.String("{location}"),
 * Name: pulumi.String("{formulaName}"),
 * ResourceGroupName: pulumi.String("resourceGroupName"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Formula;
 * import com.pulumi.azurenative.devtestlab.FormulaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var formula = new Formula("formula", FormulaArgs.builder()
 *             .description("Formula using a Linux base")
 *             .formulaContent(Map.ofEntries(
 *                 Map.entry("allowClaim", false),
 *                 Map.entry("artifacts", Map.ofEntries(
 *                     Map.entry("artifactId", "/artifactsources/{artifactSourceName}/artifacts/linux-install-nodejs"),
 *                     Map.entry("parameters", )
 *                 )),
 *                 Map.entry("disallowPublicIpAddress", true),
 *                 Map.entry("galleryImageReference", Map.ofEntries(
 *                     Map.entry("offer", "0001-com-ubuntu-server-groovy"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("publisher", "canonical"),
 *                     Map.entry("sku", "20_10"),
 *                     Map.entry("version", "latest")
 *                 )),
 *                 Map.entry("isAuthenticationWithSshKey", false),
 *                 Map.entry("labSubnetName", "Dtl{labName}Subnet"),
 *                 Map.entry("labVirtualNetworkId", "/virtualnetworks/dtl{labName}"),
 *                 Map.entry("location", "{location}"),
 *                 Map.entry("networkInterface", Map.of("sharedPublicIpAddressConfiguration", Map.of("inboundNatRules", Map.ofEntries(
 *                     Map.entry("backendPort", 22),
 *                     Map.entry("transportProtocol", "Tcp")
 *                 )))),
 *                 Map.entry("notes", "Ubuntu Server 20.10"),
 *                 Map.entry("size", "Standard_B1ms"),
 *                 Map.entry("storageType", "Standard"),
 *                 Map.entry("userName", "user")
 *             ))
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("{formulaName}")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Formula {formulaName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/formulas/{name}
 * ```
 */
public class Formula internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.Formula,
) : KotlinCustomResource(javaResource, FormulaMapper) {
    /**
     * The author of the formula.
     */
    public val author: Output<String>
        get() = javaResource.author().applyValue({ args0 -> args0 })

    /**
     * The creation date of the formula.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The description of the formula.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The content of the formula.
     */
    public val formulaContent: Output<LabVirtualMachineCreationParameterResponse>?
        get() = javaResource.formulaContent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    labVirtualMachineCreationParameterResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The OS type of the formula.
     */
    public val osType: Output<String>?
        get() = javaResource.osType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })

    /**
     * Information about a VM from which a formula is to be created.
     */
    public val vm: Output<FormulaPropertiesFromVmResponse>?
        get() = javaResource.vm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    formulaPropertiesFromVmResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object FormulaMapper : ResourceMapper<Formula> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.Formula::class == javaResource::class

    override fun map(javaResource: Resource): Formula = Formula(
        javaResource as
            com.pulumi.azurenative.devtestlab.Formula,
    )
}

/**
 * @see [Formula].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Formula].
 */
public suspend fun formula(name: String, block: suspend FormulaResourceBuilder.() -> Unit):
    Formula {
    val builder = FormulaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Formula].
 * @param name The _unique_ name of the resulting resource.
 */
public fun formula(name: String): Formula {
    val builder = FormulaResourceBuilder()
    builder.name(name)
    return builder.build()
}
