@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.FormulaArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.FormulaPropertiesFromVmArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.FormulaPropertiesFromVmArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.LabVirtualMachineCreationParameterArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.LabVirtualMachineCreationParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A formula for creating a VM, specifying an image base and other parameters
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Formulas_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var formula = new AzureNative.DevTestLab.Formula("formula", new()
 *     {
 *         Description = "Formula using a Linux base",
 *         FormulaContent = new AzureNative.DevTestLab.Inputs.LabVirtualMachineCreationParameterArgs
 *         {
 *             AllowClaim = false,
 *             Artifacts = new[]
 *             {
 *                 new AzureNative.DevTestLab.Inputs.ArtifactInstallPropertiesArgs
 *                 {
 *                     ArtifactId = "/artifactsources/{artifactSourceName}/artifacts/linux-install-nodejs",
 *                     Parameters = new[] {},
 *                 },
 *             },
 *             DisallowPublicIpAddress = true,
 *             GalleryImageReference = new AzureNative.DevTestLab.Inputs.GalleryImageReferenceArgs
 *             {
 *                 Offer = "0001-com-ubuntu-server-groovy",
 *                 OsType = "Linux",
 *                 Publisher = "canonical",
 *                 Sku = "20_10",
 *                 Version = "latest",
 *             },
 *             IsAuthenticationWithSshKey = false,
 *             LabSubnetName = "Dtl{labName}Subnet",
 *             LabVirtualNetworkId = "/virtualnetworks/dtl{labName}",
 *             Location = "{location}",
 *             NetworkInterface = new AzureNative.DevTestLab.Inputs.NetworkInterfacePropertiesArgs
 *             {
 *                 SharedPublicIpAddressConfiguration = new AzureNative.DevTestLab.Inputs.SharedPublicIpAddressConfigurationArgs
 *                 {
 *                     InboundNatRules = new[]
 *                     {
 *                         new AzureNative.DevTestLab.Inputs.InboundNatRuleArgs
 *                         {
 *                             BackendPort = 22,
 *                             TransportProtocol = "Tcp",
 *                         },
 *                     },
 *                 },
 *             },
 *             Notes = "Ubuntu Server 20.10",
 *             Size = "Standard_B1ms",
 *             StorageType = "Standard",
 *             UserName = "user",
 *         },
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "{formulaName}",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := devtestlab.NewFormula(ctx, "formula", &devtestlab.FormulaArgs{
 * Description: pulumi.String("Formula using a Linux base"),
 * FormulaContent: devtestlab.LabVirtualMachineCreationParameterResponse{
 * AllowClaim: pulumi.Bool(false),
 * Artifacts: devtestlab.ArtifactInstallPropertiesArray{
 * interface{}{
 * ArtifactId: pulumi.String("/artifactsources/{artifactSourceName}/artifacts/linux-install-nodejs"),
 * Parameters: devtestlab.ArtifactParameterPropertiesArray{
 * },
 * },
 * },
 * DisallowPublicIpAddress: pulumi.Bool(true),
 * GalleryImageReference: &devtestlab.GalleryImageReferenceArgs{
 * Offer: pulumi.String("0001-com-ubuntu-server-groovy"),
 * OsType: pulumi.String("Linux"),
 * Publisher: pulumi.String("canonical"),
 * Sku: pulumi.String("20_10"),
 * Version: pulumi.String("latest"),
 * },
 * IsAuthenticationWithSshKey: pulumi.Bool(false),
 * LabSubnetName: pulumi.String("Dtl{labName}Subnet"),
 * LabVirtualNetworkId: pulumi.String("/virtualnetworks/dtl{labName}"),
 * Location: pulumi.String("{location}"),
 * NetworkInterface: interface{}{
 * SharedPublicIpAddressConfiguration: interface{}{
 * InboundNatRules: devtestlab.InboundNatRuleArray{
 * &devtestlab.InboundNatRuleArgs{
 * BackendPort: pulumi.Int(22),
 * TransportProtocol: pulumi.String("Tcp"),
 * },
 * },
 * },
 * },
 * Notes: pulumi.String("Ubuntu Server 20.10"),
 * Size: pulumi.String("Standard_B1ms"),
 * StorageType: pulumi.String("Standard"),
 * UserName: pulumi.String("user"),
 * },
 * LabName: pulumi.String("{labName}"),
 * Location: pulumi.String("{location}"),
 * Name: pulumi.String("{formulaName}"),
 * ResourceGroupName: pulumi.String("resourceGroupName"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Formula;
 * import com.pulumi.azurenative.devtestlab.FormulaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var formula = new Formula("formula", FormulaArgs.builder()
 *             .description("Formula using a Linux base")
 *             .formulaContent(Map.ofEntries(
 *                 Map.entry("allowClaim", false),
 *                 Map.entry("artifacts", Map.ofEntries(
 *                     Map.entry("artifactId", "/artifactsources/{artifactSourceName}/artifacts/linux-install-nodejs"),
 *                     Map.entry("parameters", )
 *                 )),
 *                 Map.entry("disallowPublicIpAddress", true),
 *                 Map.entry("galleryImageReference", Map.ofEntries(
 *                     Map.entry("offer", "0001-com-ubuntu-server-groovy"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("publisher", "canonical"),
 *                     Map.entry("sku", "20_10"),
 *                     Map.entry("version", "latest")
 *                 )),
 *                 Map.entry("isAuthenticationWithSshKey", false),
 *                 Map.entry("labSubnetName", "Dtl{labName}Subnet"),
 *                 Map.entry("labVirtualNetworkId", "/virtualnetworks/dtl{labName}"),
 *                 Map.entry("location", "{location}"),
 *                 Map.entry("networkInterface", Map.of("sharedPublicIpAddressConfiguration", Map.of("inboundNatRules", Map.ofEntries(
 *                     Map.entry("backendPort", 22),
 *                     Map.entry("transportProtocol", "Tcp")
 *                 )))),
 *                 Map.entry("notes", "Ubuntu Server 20.10"),
 *                 Map.entry("size", "Standard_B1ms"),
 *                 Map.entry("storageType", "Standard"),
 *                 Map.entry("userName", "user")
 *             ))
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("{formulaName}")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Formula {formulaName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/formulas/{name}
 * ```
 * @property description The description of the formula.
 * @property formulaContent The content of the formula.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property name The name of the formula.
 * @property osType The OS type of the formula.
 * @property resourceGroupName The name of the resource group.
 * @property tags The tags of the resource.
 * @property vm Information about a VM from which a formula is to be created.
 */
public data class FormulaArgs(
    public val description: Output<String>? = null,
    public val formulaContent: Output<LabVirtualMachineCreationParameterArgs>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val osType: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vm: Output<FormulaPropertiesFromVmArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.FormulaArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.FormulaArgs =
        com.pulumi.azurenative.devtestlab.FormulaArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .formulaContent(formulaContent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vm(vm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FormulaArgs].
 */
@PulumiTagMarker
public class FormulaArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var formulaContent: Output<LabVirtualMachineCreationParameterArgs>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var osType: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vm: Output<FormulaPropertiesFromVmArgs>? = null

    /**
     * @param value The description of the formula.
     */
    @JvmName("hayrxxrwamnujsvk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The content of the formula.
     */
    @JvmName("yphrxhjhpgnkdbrv")
    public suspend fun formulaContent(`value`: Output<LabVirtualMachineCreationParameterArgs>) {
        this.formulaContent = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("rtcepgfvduvdjlsw")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("bogcyykvfdmqeuap")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the formula.
     */
    @JvmName("henwyaqmxgfycgtm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The OS type of the formula.
     */
    @JvmName("gdiotvqgvacqdmbh")
    public suspend fun osType(`value`: Output<String>) {
        this.osType = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hasxiovvlymhsctf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("ywtaasoggcficang")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Information about a VM from which a formula is to be created.
     */
    @JvmName("oqurjtoudaspjxxh")
    public suspend fun vm(`value`: Output<FormulaPropertiesFromVmArgs>) {
        this.vm = value
    }

    /**
     * @param value The description of the formula.
     */
    @JvmName("ffwiuaglbcxmtxsh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The content of the formula.
     */
    @JvmName("qbulyupafbqudrvf")
    public suspend fun formulaContent(`value`: LabVirtualMachineCreationParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.formulaContent = mapped
    }

    /**
     * @param argument The content of the formula.
     */
    @JvmName("isescecbhuvrddoy")
    public suspend
    fun formulaContent(argument: suspend LabVirtualMachineCreationParameterArgsBuilder.() -> Unit) {
        val toBeMapped = LabVirtualMachineCreationParameterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.formulaContent = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("wmjwcdbgirjwrfwb")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("lynkpwutejuxfbex")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the formula.
     */
    @JvmName("larbewlrdqmdfopc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The OS type of the formula.
     */
    @JvmName("suqqworeckiivrxf")
    public suspend fun osType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("exiskxmcaokcvcke")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("vhvbwtajxwrunoot")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("vxrlngdiniyfctea")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Information about a VM from which a formula is to be created.
     */
    @JvmName("gyjgppiuudgygppn")
    public suspend fun vm(`value`: FormulaPropertiesFromVmArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vm = mapped
    }

    /**
     * @param argument Information about a VM from which a formula is to be created.
     */
    @JvmName("vpgdawmeytiakxhr")
    public suspend fun vm(argument: suspend FormulaPropertiesFromVmArgsBuilder.() -> Unit) {
        val toBeMapped = FormulaPropertiesFromVmArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vm = mapped
    }

    internal fun build(): FormulaArgs = FormulaArgs(
        description = description,
        formulaContent = formulaContent,
        labName = labName,
        location = location,
        name = name,
        osType = osType,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vm = vm,
    )
}
