@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.NotificationChannelArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.EventArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.EventArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A notification.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### NotificationChannels_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var notificationChannel = new AzureNative.DevTestLab.NotificationChannel("notificationChannel", new()
 *     {
 *         Description = "Integration configured for auto-shutdown",
 *         EmailRecipient = "{email}",
 *         Events = new[]
 *         {
 *             new AzureNative.DevTestLab.Inputs.EventArgs
 *             {
 *                 EventName = "AutoShutdown",
 *             },
 *         },
 *         LabName = "{labName}",
 *         Name = "{notificationChannelName}",
 *         NotificationLocale = "en",
 *         ResourceGroupName = "resourceGroupName",
 *         WebHookUrl = "{webhookUrl}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewNotificationChannel(ctx, "notificationChannel", &devtestlab.NotificationChannelArgs{
 * 			Description:    pulumi.String("Integration configured for auto-shutdown"),
 * 			EmailRecipient: pulumi.String("{email}"),
 * 			Events: []devtestlab.EventArgs{
 * 				{
 * 					EventName: pulumi.String("AutoShutdown"),
 * 				},
 * 			},
 * 			LabName:            pulumi.String("{labName}"),
 * 			Name:               pulumi.String("{notificationChannelName}"),
 * 			NotificationLocale: pulumi.String("en"),
 * 			ResourceGroupName:  pulumi.String("resourceGroupName"),
 * 			WebHookUrl:         pulumi.String("{webhookUrl}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.NotificationChannel;
 * import com.pulumi.azurenative.devtestlab.NotificationChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var notificationChannel = new NotificationChannel("notificationChannel", NotificationChannelArgs.builder()
 *             .description("Integration configured for auto-shutdown")
 *             .emailRecipient("{email}")
 *             .events(Map.of("eventName", "AutoShutdown"))
 *             .labName("{labName}")
 *             .name("{notificationChannelName}")
 *             .notificationLocale("en")
 *             .resourceGroupName("resourceGroupName")
 *             .webHookUrl("{webhookUrl}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:NotificationChannel {notificationChannelName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/notificationchannels/{name}
 * ```
 * @property description Description of notification.
 * @property emailRecipient The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
 * @property events The list of event for which this notification is enabled.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property name The name of the notification channel.
 * @property notificationLocale The locale to use when sending a notification (fallback for unsupported languages is EN).
 * @property resourceGroupName The name of the resource group.
 * @property tags The tags of the resource.
 * @property webHookUrl The webhook URL to send notifications to.
 */
public data class NotificationChannelArgs(
    public val description: Output<String>? = null,
    public val emailRecipient: Output<String>? = null,
    public val events: Output<List<EventArgs>>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val notificationLocale: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val webHookUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.NotificationChannelArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.NotificationChannelArgs =
        com.pulumi.azurenative.devtestlab.NotificationChannelArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .emailRecipient(emailRecipient?.applyValue({ args0 -> args0 }))
            .events(events?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notificationLocale(notificationLocale?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .webHookUrl(webHookUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotificationChannelArgs].
 */
@PulumiTagMarker
public class NotificationChannelArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var emailRecipient: Output<String>? = null

    private var events: Output<List<EventArgs>>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var notificationLocale: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var webHookUrl: Output<String>? = null

    /**
     * @param value Description of notification.
     */
    @JvmName("gwcfnwplecpqftga")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
     */
    @JvmName("rpnhwllxbbqnbsdx")
    public suspend fun emailRecipient(`value`: Output<String>) {
        this.emailRecipient = value
    }

    /**
     * @param value The list of event for which this notification is enabled.
     */
    @JvmName("rqjhbjnvibgjplef")
    public suspend fun events(`value`: Output<List<EventArgs>>) {
        this.events = value
    }

    @JvmName("juihwrvwfniunhkk")
    public suspend fun events(vararg values: Output<EventArgs>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values The list of event for which this notification is enabled.
     */
    @JvmName("gqgdenrodmavsguh")
    public suspend fun events(values: List<Output<EventArgs>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("bngeyrcyfdwfhdix")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("uwbaubooymxdttnf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the notification channel.
     */
    @JvmName("dsjrjqbtylctvcab")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The locale to use when sending a notification (fallback for unsupported languages is EN).
     */
    @JvmName("tlbhaltspdwasdkn")
    public suspend fun notificationLocale(`value`: Output<String>) {
        this.notificationLocale = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nnkbalregtnfgpkj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("cnhsmpxycpfnnerq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The webhook URL to send notifications to.
     */
    @JvmName("goprtkersjlafjpo")
    public suspend fun webHookUrl(`value`: Output<String>) {
        this.webHookUrl = value
    }

    /**
     * @param value Description of notification.
     */
    @JvmName("khnxqptbuxcsaufw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
     */
    @JvmName("ysrdheslawqkhusu")
    public suspend fun emailRecipient(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailRecipient = mapped
    }

    /**
     * @param value The list of event for which this notification is enabled.
     */
    @JvmName("rmavfptuwqrhtjux")
    public suspend fun events(`value`: List<EventArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param argument The list of event for which this notification is enabled.
     */
    @JvmName("cmwghuqqlqwixejr")
    public suspend fun events(argument: List<suspend EventArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { EventArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param argument The list of event for which this notification is enabled.
     */
    @JvmName("bteukmoodgswmsxl")
    public suspend fun events(vararg argument: suspend EventArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { EventArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param argument The list of event for which this notification is enabled.
     */
    @JvmName("chxotppqexevvdnq")
    public suspend fun events(argument: suspend EventArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param values The list of event for which this notification is enabled.
     */
    @JvmName("pcqaiwlwbuqytvjb")
    public suspend fun events(vararg values: EventArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("njbtaqkjrynmqfqq")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("cevlsymjtlrovfnw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the notification channel.
     */
    @JvmName("rtmsagmiqvjtfikf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The locale to use when sending a notification (fallback for unsupported languages is EN).
     */
    @JvmName("iqcmnitiapjwouho")
    public suspend fun notificationLocale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationLocale = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("iegcdecfygssqcth")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("hixxgvwmcfjgqatv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("vjiomnlneasypjnm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The webhook URL to send notifications to.
     */
    @JvmName("usdoajmxpringfqc")
    public suspend fun webHookUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webHookUrl = mapped
    }

    internal fun build(): NotificationChannelArgs = NotificationChannelArgs(
        description = description,
        emailRecipient = emailRecipient,
        events = events,
        labName = labName,
        location = location,
        name = name,
        notificationLocale = notificationLocale,
        resourceGroupName = resourceGroupName,
        tags = tags,
        webHookUrl = webHookUrl,
    )
}
