@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.PolicyArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.PolicyEvaluatorType
import com.pulumi.azurenative.devtestlab.kotlin.enums.PolicyFactName
import com.pulumi.azurenative.devtestlab.kotlin.enums.PolicyStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Policy.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Policies_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new AzureNative.DevTestLab.Policy("policy", new()
 *     {
 *         Description = "{policyDescription}",
 *         EvaluatorType = "{policyEvaluatorType}",
 *         FactData = "{policyFactData}",
 *         FactName = "{policyFactName}",
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "{policyName}",
 *         PolicySetName = "{policySetName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Status = "{policyStatus}",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         Threshold = "{policyThreshold}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewPolicy(ctx, "policy", &devtestlab.PolicyArgs{
 * 			Description:       pulumi.String("{policyDescription}"),
 * 			EvaluatorType:     pulumi.String("{policyEvaluatorType}"),
 * 			FactData:          pulumi.String("{policyFactData}"),
 * 			FactName:          pulumi.String("{policyFactName}"),
 * 			LabName:           pulumi.String("{labName}"),
 * 			Location:          pulumi.String("{location}"),
 * 			Name:              pulumi.String("{policyName}"),
 * 			PolicySetName:     pulumi.String("{policySetName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Status:            pulumi.String("{policyStatus}"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			Threshold: pulumi.String("{policyThreshold}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Policy;
 * import com.pulumi.azurenative.devtestlab.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .description("{policyDescription}")
 *             .evaluatorType("{policyEvaluatorType}")
 *             .factData("{policyFactData}")
 *             .factName("{policyFactName}")
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("{policyName}")
 *             .policySetName("{policySetName}")
 *             .resourceGroupName("resourceGroupName")
 *             .status("{policyStatus}")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .threshold("{policyThreshold}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Policy {labName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/policysets/{policySetName}/policies/{name}
 * ```
 * @property description The description of the policy.
 * @property evaluatorType The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy).
 * @property factData The fact data of the policy.
 * @property factName The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property name The name of the policy.
 * @property policySetName The name of the policy set.
 * @property resourceGroupName The name of the resource group.
 * @property status The status of the policy.
 * @property tags The tags of the resource.
 * @property threshold The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
 */
public data class PolicyArgs(
    public val description: Output<String>? = null,
    public val evaluatorType: Output<Either<String, PolicyEvaluatorType>>? = null,
    public val factData: Output<String>? = null,
    public val factName: Output<Either<String, PolicyFactName>>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policySetName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<Either<String, PolicyStatus>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val threshold: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.PolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.PolicyArgs =
        com.pulumi.azurenative.devtestlab.PolicyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .evaluatorType(
                evaluatorType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .factData(factData?.applyValue({ args0 -> args0 }))
            .factName(
                factName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policySetName(policySetName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .threshold(threshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var evaluatorType: Output<Either<String, PolicyEvaluatorType>>? = null

    private var factData: Output<String>? = null

    private var factName: Output<Either<String, PolicyFactName>>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var policySetName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<Either<String, PolicyStatus>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var threshold: Output<String>? = null

    /**
     * @param value The description of the policy.
     */
    @JvmName("mrdpgxtojvlglmyd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy).
     */
    @JvmName("gvburbelryqfysgj")
    public suspend fun evaluatorType(`value`: Output<Either<String, PolicyEvaluatorType>>) {
        this.evaluatorType = value
    }

    /**
     * @param value The fact data of the policy.
     */
    @JvmName("xrhnunqnepxeyrbt")
    public suspend fun factData(`value`: Output<String>) {
        this.factData = value
    }

    /**
     * @param value The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc.
     */
    @JvmName("snfmuamengilcfle")
    public suspend fun factName(`value`: Output<Either<String, PolicyFactName>>) {
        this.factName = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("mjiovpyjsdaegdrv")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("nwuqicjfcreujbir")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("xsotabwthmejoqyh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the policy set.
     */
    @JvmName("lealohcnqtbxcaxp")
    public suspend fun policySetName(`value`: Output<String>) {
        this.policySetName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nkcwmvwssmdxratj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The status of the policy.
     */
    @JvmName("ruymwcxrwqprcmqh")
    public suspend fun status(`value`: Output<Either<String, PolicyStatus>>) {
        this.status = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("sfuqaohgtlwmqbmc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
     */
    @JvmName("tfoxaanekgwsaqhu")
    public suspend fun threshold(`value`: Output<String>) {
        this.threshold = value
    }

    /**
     * @param value The description of the policy.
     */
    @JvmName("jtcvfivlwoaqodob")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy).
     */
    @JvmName("reldvbpndfocwibs")
    public suspend fun evaluatorType(`value`: Either<String, PolicyEvaluatorType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluatorType = mapped
    }

    /**
     * @param value The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy).
     */
    @JvmName("sbbuhxaceoaifnef")
    public fun evaluatorType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyEvaluatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evaluatorType = mapped
    }

    /**
     * @param value The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy).
     */
    @JvmName("djisyisdjbxtnnia")
    public fun evaluatorType(`value`: PolicyEvaluatorType) {
        val toBeMapped = Either.ofRight<String, PolicyEvaluatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evaluatorType = mapped
    }

    /**
     * @param value The fact data of the policy.
     */
    @JvmName("tveyxxsuanvsbhtk")
    public suspend fun factData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factData = mapped
    }

    /**
     * @param value The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc.
     */
    @JvmName("uusywrqmfyveaeat")
    public suspend fun factName(`value`: Either<String, PolicyFactName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factName = mapped
    }

    /**
     * @param value The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc.
     */
    @JvmName("jhrfevgentiohlnj")
    public fun factName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyFactName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.factName = mapped
    }

    /**
     * @param value The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc.
     */
    @JvmName("rljsvsnothgvavrm")
    public fun factName(`value`: PolicyFactName) {
        val toBeMapped = Either.ofRight<String, PolicyFactName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.factName = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("iuuyawkdsuarauha")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("vshtfwgriaarhroi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("hacuqrulyanjmtdu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the policy set.
     */
    @JvmName("hngcxlwjsvsguqcw")
    public suspend fun policySetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policySetName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ltogwsgpiroitrlc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The status of the policy.
     */
    @JvmName("fiqffmbuwxwjotvq")
    public suspend fun status(`value`: Either<String, PolicyStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the policy.
     */
    @JvmName("ktiespupqbterwgf")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the policy.
     */
    @JvmName("pxslqlawlkehhcvh")
    public fun status(`value`: PolicyStatus) {
        val toBeMapped = Either.ofRight<String, PolicyStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("prvrdltgmeqphcea")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("hmpklrvrvsyrtdie")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
     */
    @JvmName("nlriogslfloxhnud")
    public suspend fun threshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        description = description,
        evaluatorType = evaluatorType,
        factData = factData,
        factName = factName,
        labName = labName,
        location = location,
        name = name,
        policySetName = policySetName,
        resourceGroupName = resourceGroupName,
        status = status,
        tags = tags,
        threshold = threshold,
    )
}
