@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.DayDetailsResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.HourDetailsResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.NotificationSettingsResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.WeekDetailsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devtestlab.kotlin.outputs.DayDetailsResponse.Companion.toKotlin as dayDetailsResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.HourDetailsResponse.Companion.toKotlin as hourDetailsResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.NotificationSettingsResponse.Companion.toKotlin as notificationSettingsResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.WeekDetailsResponse.Companion.toKotlin as weekDetailsResponseToKotlin

/**
 * Builder for [Schedule].
 */
@PulumiTagMarker
public class ScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduleArgs = ScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduleArgsBuilder.() -> Unit) {
        val builder = ScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Schedule {
        val builtJavaResource = com.pulumi.azurenative.devtestlab.Schedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schedule(builtJavaResource)
    }
}

/**
 * A schedule.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Schedules_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new AzureNative.DevTestLab.Schedule("schedule", new()
 *     {
 *         DailyRecurrence = new AzureNative.DevTestLab.Inputs.DayDetailsArgs
 *         {
 *             Time = "{timeOfTheDayTheScheduleWillOccurEveryDay}",
 *         },
 *         HourlyRecurrence = new AzureNative.DevTestLab.Inputs.HourDetailsArgs
 *         {
 *             Minute = 30,
 *         },
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "{scheduleName}",
 *         NotificationSettings = new AzureNative.DevTestLab.Inputs.NotificationSettingsArgs
 *         {
 *             EmailRecipient = "{email}",
 *             NotificationLocale = "EN",
 *             Status = "{Enabled|Disabled}",
 *             TimeInMinutes = 15,
 *             WebhookUrl = "{webhookUrl}",
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         Status = "{Enabled|Disabled}",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         TargetResourceId = "/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}",
 *         TaskType = "{myLabVmTaskType}",
 *         TimeZoneId = "Pacific Standard Time",
 *         WeeklyRecurrence = new AzureNative.DevTestLab.Inputs.WeekDetailsArgs
 *         {
 *             Time = "{timeOfTheDayTheScheduleWillOccurOnThoseDays}",
 *             Weekdays = new[]
 *             {
 *                 "Monday",
 *                 "Wednesday",
 *                 "Friday",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewSchedule(ctx, "schedule", &devtestlab.ScheduleArgs{
 * 			DailyRecurrence: &devtestlab.DayDetailsArgs{
 * 				Time: pulumi.String("{timeOfTheDayTheScheduleWillOccurEveryDay}"),
 * 			},
 * 			HourlyRecurrence: &devtestlab.HourDetailsArgs{
 * 				Minute: pulumi.Int(30),
 * 			},
 * 			LabName:  pulumi.String("{labName}"),
 * 			Location: pulumi.String("{location}"),
 * 			Name:     pulumi.String("{scheduleName}"),
 * 			NotificationSettings: &devtestlab.NotificationSettingsArgs{
 * 				EmailRecipient:     pulumi.String("{email}"),
 * 				NotificationLocale: pulumi.String("EN"),
 * 				Status:             pulumi.String("{Enabled|Disabled}"),
 * 				TimeInMinutes:      pulumi.Int(15),
 * 				WebhookUrl:         pulumi.String("{webhookUrl}"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Status:            pulumi.String("{Enabled|Disabled}"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			TargetResourceId: pulumi.String("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}"),
 * 			TaskType:         pulumi.String("{myLabVmTaskType}"),
 * 			TimeZoneId:       pulumi.String("Pacific Standard Time"),
 * 			WeeklyRecurrence: &devtestlab.WeekDetailsArgs{
 * 				Time: pulumi.String("{timeOfTheDayTheScheduleWillOccurOnThoseDays}"),
 * 				Weekdays: pulumi.StringArray{
 * 					pulumi.String("Monday"),
 * 					pulumi.String("Wednesday"),
 * 					pulumi.String("Friday"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Schedule;
 * import com.pulumi.azurenative.devtestlab.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new Schedule("schedule", ScheduleArgs.builder()
 *             .dailyRecurrence(Map.of("time", "{timeOfTheDayTheScheduleWillOccurEveryDay}"))
 *             .hourlyRecurrence(Map.of("minute", 30))
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("{scheduleName}")
 *             .notificationSettings(Map.ofEntries(
 *                 Map.entry("emailRecipient", "{email}"),
 *                 Map.entry("notificationLocale", "EN"),
 *                 Map.entry("status", "{Enabled|Disabled}"),
 *                 Map.entry("timeInMinutes", 15),
 *                 Map.entry("webhookUrl", "{webhookUrl}")
 *             ))
 *             .resourceGroupName("resourceGroupName")
 *             .status("{Enabled|Disabled}")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .targetResourceId("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}")
 *             .taskType("{myLabVmTaskType}")
 *             .timeZoneId("Pacific Standard Time")
 *             .weeklyRecurrence(Map.ofEntries(
 *                 Map.entry("time", "{timeOfTheDayTheScheduleWillOccurOnThoseDays}"),
 *                 Map.entry("weekdays",
 *                     "Monday",
 *                     "Wednesday",
 *                     "Friday")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Schedule {scheduleName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/schedules/{name}
 * ```
 */
public class Schedule internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.Schedule,
) : KotlinCustomResource(javaResource, ScheduleMapper) {
    /**
     * The creation date of the schedule.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * If the schedule will occur once each day of the week, specify the daily recurrence.
     */
    public val dailyRecurrence: Output<DayDetailsResponse>?
        get() = javaResource.dailyRecurrence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dayDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * If the schedule will occur multiple times a day, specify the hourly recurrence.
     */
    public val hourlyRecurrence: Output<HourDetailsResponse>?
        get() = javaResource.hourlyRecurrence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hourDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Notification settings.
     */
    public val notificationSettings: Output<NotificationSettingsResponse>?
        get() = javaResource.notificationSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> notificationSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The status of the schedule (i.e. Enabled, Disabled)
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource ID to which the schedule belongs
     */
    public val targetResourceId: Output<String>?
        get() = javaResource.targetResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
     */
    public val taskType: Output<String>?
        get() = javaResource.taskType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
     */
    public val timeZoneId: Output<String>?
        get() = javaResource.timeZoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })

    /**
     * If the schedule will occur only some days of the week, specify the weekly recurrence.
     */
    public val weeklyRecurrence: Output<WeekDetailsResponse>?
        get() = javaResource.weeklyRecurrence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> weekDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })
}

public object ScheduleMapper : ResourceMapper<Schedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.Schedule::class == javaResource::class

    override fun map(javaResource: Resource): Schedule = Schedule(
        javaResource as
            com.pulumi.azurenative.devtestlab.Schedule,
    )
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schedule].
 */
public suspend fun schedule(name: String, block: suspend ScheduleResourceBuilder.() -> Unit):
    Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schedule(name: String): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
