@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.ServiceFabricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Service Fabric.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * ## Example Usage
 * ### ServiceFabrics_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceFabric = new AzureNative.DevTestLab.ServiceFabric("serviceFabric", new()
 *     {
 *         EnvironmentId = "{environmentId}",
 *         ExternalServiceFabricId = "{serviceFabricId}",
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "{serviceFabricName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         UserName = "{userName}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewServiceFabric(ctx, "serviceFabric", &devtestlab.ServiceFabricArgs{
 * 			EnvironmentId:           pulumi.String("{environmentId}"),
 * 			ExternalServiceFabricId: pulumi.String("{serviceFabricId}"),
 * 			LabName:                 pulumi.String("{labName}"),
 * 			Location:                pulumi.String("{location}"),
 * 			Name:                    pulumi.String("{serviceFabricName}"),
 * 			ResourceGroupName:       pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			UserName: pulumi.String("{userName}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.ServiceFabric;
 * import com.pulumi.azurenative.devtestlab.ServiceFabricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceFabric = new ServiceFabric("serviceFabric", ServiceFabricArgs.builder()
 *             .environmentId("{environmentId}")
 *             .externalServiceFabricId("{serviceFabricId}")
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("{serviceFabricName}")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .userName("{userName}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:ServiceFabric {serviceFabricName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/servicefabrics/{name}
 * ```
 * @property environmentId The resource id of the environment under which the service fabric resource is present
 * @property externalServiceFabricId The backing service fabric resource's id
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property name The name of the service fabric.
 * @property resourceGroupName The name of the resource group.
 * @property tags The tags of the resource.
 * @property userName The name of the user profile.
 */
public data class ServiceFabricArgs(
    public val environmentId: Output<String>? = null,
    public val externalServiceFabricId: Output<String>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.ServiceFabricArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.ServiceFabricArgs =
        com.pulumi.azurenative.devtestlab.ServiceFabricArgs.builder()
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .externalServiceFabricId(externalServiceFabricId?.applyValue({ args0 -> args0 }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceFabricArgs].
 */
@PulumiTagMarker
public class ServiceFabricArgsBuilder internal constructor() {
    private var environmentId: Output<String>? = null

    private var externalServiceFabricId: Output<String>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The resource id of the environment under which the service fabric resource is present
     */
    @JvmName("uxwqpobienldqyka")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value The backing service fabric resource's id
     */
    @JvmName("nlfsunjqirtgxrit")
    public suspend fun externalServiceFabricId(`value`: Output<String>) {
        this.externalServiceFabricId = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("dicqnkendyxgdweo")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("owthpuitbvdaowoa")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the service fabric.
     */
    @JvmName("sbiixlcbogbgwrwt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("eyjsyerfcffydedv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("dsbbohcfetriaivj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the user profile.
     */
    @JvmName("ftpwhntwxanvjrjv")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The resource id of the environment under which the service fabric resource is present
     */
    @JvmName("osihbgisdkknlnkn")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value The backing service fabric resource's id
     */
    @JvmName("icbbklanayiilihb")
    public suspend fun externalServiceFabricId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalServiceFabricId = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("xiwrrssjdagcbisp")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("micwkpxjvatwpuqg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the service fabric.
     */
    @JvmName("avyjkcratjbtmlho")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hojfrnemltnakkej")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("ijtgfisextjavdpo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("svodxlydvdhajftu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the user profile.
     */
    @JvmName("hdimiherfbahmxmu")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): ServiceFabricArgs = ServiceFabricArgs(
        environmentId = environmentId,
        externalServiceFabricId = externalServiceFabricId,
        labName = labName,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        tags = tags,
        userName = userName,
    )
}
