@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.VirtualMachineScheduleArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.EnableStatus
import com.pulumi.azurenative.devtestlab.kotlin.inputs.DayDetailsArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.DayDetailsArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.HourDetailsArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.HourDetailsArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.NotificationSettingsArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.NotificationSettingsArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.WeekDetailsArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.WeekDetailsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A schedule.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### VirtualMachineSchedules_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineSchedule = new AzureNative.DevTestLab.VirtualMachineSchedule("virtualMachineSchedule", new()
 *     {
 *         DailyRecurrence = new AzureNative.DevTestLab.Inputs.DayDetailsArgs
 *         {
 *             Time = "1900",
 *         },
 *         HourlyRecurrence = new AzureNative.DevTestLab.Inputs.HourDetailsArgs
 *         {
 *             Minute = 30,
 *         },
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "LabVmsShutdown",
 *         NotificationSettings = new AzureNative.DevTestLab.Inputs.NotificationSettingsArgs
 *         {
 *             EmailRecipient = "{email}",
 *             NotificationLocale = "EN",
 *             Status = "Enabled",
 *             TimeInMinutes = 30,
 *             WebhookUrl = "{webhookUrl}",
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         Status = "Enabled",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         TargetResourceId = "/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualMachines/{vmName}",
 *         TaskType = "LabVmsShutdownTask",
 *         TimeZoneId = "Pacific Standard Time",
 *         VirtualMachineName = "{vmName}",
 *         WeeklyRecurrence = new AzureNative.DevTestLab.Inputs.WeekDetailsArgs
 *         {
 *             Time = "1700",
 *             Weekdays = new[]
 *             {
 *                 "Friday",
 *                 "Saturday",
 *                 "Sunday",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewVirtualMachineSchedule(ctx, "virtualMachineSchedule", &devtestlab.VirtualMachineScheduleArgs{
 * 			DailyRecurrence: &devtestlab.DayDetailsArgs{
 * 				Time: pulumi.String("1900"),
 * 			},
 * 			HourlyRecurrence: &devtestlab.HourDetailsArgs{
 * 				Minute: pulumi.Int(30),
 * 			},
 * 			LabName:  pulumi.String("{labName}"),
 * 			Location: pulumi.String("{location}"),
 * 			Name:     pulumi.String("LabVmsShutdown"),
 * 			NotificationSettings: &devtestlab.NotificationSettingsArgs{
 * 				EmailRecipient:     pulumi.String("{email}"),
 * 				NotificationLocale: pulumi.String("EN"),
 * 				Status:             pulumi.String("Enabled"),
 * 				TimeInMinutes:      pulumi.Int(30),
 * 				WebhookUrl:         pulumi.String("{webhookUrl}"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Status:            pulumi.String("Enabled"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			TargetResourceId:   pulumi.String("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualMachines/{vmName}"),
 * 			TaskType:           pulumi.String("LabVmsShutdownTask"),
 * 			TimeZoneId:         pulumi.String("Pacific Standard Time"),
 * 			VirtualMachineName: pulumi.String("{vmName}"),
 * 			WeeklyRecurrence: &devtestlab.WeekDetailsArgs{
 * 				Time: pulumi.String("1700"),
 * 				Weekdays: pulumi.StringArray{
 * 					pulumi.String("Friday"),
 * 					pulumi.String("Saturday"),
 * 					pulumi.String("Sunday"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.VirtualMachineSchedule;
 * import com.pulumi.azurenative.devtestlab.VirtualMachineScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineSchedule = new VirtualMachineSchedule("virtualMachineSchedule", VirtualMachineScheduleArgs.builder()
 *             .dailyRecurrence(Map.of("time", "1900"))
 *             .hourlyRecurrence(Map.of("minute", 30))
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("LabVmsShutdown")
 *             .notificationSettings(Map.ofEntries(
 *                 Map.entry("emailRecipient", "{email}"),
 *                 Map.entry("notificationLocale", "EN"),
 *                 Map.entry("status", "Enabled"),
 *                 Map.entry("timeInMinutes", 30),
 *                 Map.entry("webhookUrl", "{webhookUrl}")
 *             ))
 *             .resourceGroupName("resourceGroupName")
 *             .status("Enabled")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .targetResourceId("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualMachines/{vmName}")
 *             .taskType("LabVmsShutdownTask")
 *             .timeZoneId("Pacific Standard Time")
 *             .virtualMachineName("{vmName}")
 *             .weeklyRecurrence(Map.ofEntries(
 *                 Map.entry("time", "1700"),
 *                 Map.entry("weekdays",
 *                     "Friday",
 *                     "Saturday",
 *                     "Sunday")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:VirtualMachineSchedule LabVmsShutdown /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{virtualMachineName}/schedules/{name}
 * ```
 * @property dailyRecurrence If the schedule will occur once each day of the week, specify the daily recurrence.
 * @property hourlyRecurrence If the schedule will occur multiple times a day, specify the hourly recurrence.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property name The name of the schedule.
 * @property notificationSettings Notification settings.
 * @property resourceGroupName The name of the resource group.
 * @property status The status of the schedule (i.e. Enabled, Disabled)
 * @property tags The tags of the resource.
 * @property targetResourceId The resource ID to which the schedule belongs
 * @property taskType The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
 * @property timeZoneId The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
 * @property virtualMachineName The name of the virtual machine.
 * @property weeklyRecurrence If the schedule will occur only some days of the week, specify the weekly recurrence.
 */
public data class VirtualMachineScheduleArgs(
    public val dailyRecurrence: Output<DayDetailsArgs>? = null,
    public val hourlyRecurrence: Output<HourDetailsArgs>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val notificationSettings: Output<NotificationSettingsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<Either<String, EnableStatus>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceId: Output<String>? = null,
    public val taskType: Output<String>? = null,
    public val timeZoneId: Output<String>? = null,
    public val virtualMachineName: Output<String>? = null,
    public val weeklyRecurrence: Output<WeekDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.VirtualMachineScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.VirtualMachineScheduleArgs =
        com.pulumi.azurenative.devtestlab.VirtualMachineScheduleArgs.builder()
            .dailyRecurrence(dailyRecurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hourlyRecurrence(hourlyRecurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notificationSettings(
                notificationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceId(targetResourceId?.applyValue({ args0 -> args0 }))
            .taskType(taskType?.applyValue({ args0 -> args0 }))
            .timeZoneId(timeZoneId?.applyValue({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 }))
            .weeklyRecurrence(
                weeklyRecurrence?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineScheduleArgs].
 */
@PulumiTagMarker
public class VirtualMachineScheduleArgsBuilder internal constructor() {
    private var dailyRecurrence: Output<DayDetailsArgs>? = null

    private var hourlyRecurrence: Output<HourDetailsArgs>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var notificationSettings: Output<NotificationSettingsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<Either<String, EnableStatus>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceId: Output<String>? = null

    private var taskType: Output<String>? = null

    private var timeZoneId: Output<String>? = null

    private var virtualMachineName: Output<String>? = null

    private var weeklyRecurrence: Output<WeekDetailsArgs>? = null

    /**
     * @param value If the schedule will occur once each day of the week, specify the daily recurrence.
     */
    @JvmName("birnqfgaqgggenon")
    public suspend fun dailyRecurrence(`value`: Output<DayDetailsArgs>) {
        this.dailyRecurrence = value
    }

    /**
     * @param value If the schedule will occur multiple times a day, specify the hourly recurrence.
     */
    @JvmName("ldfjiqiyflywjtae")
    public suspend fun hourlyRecurrence(`value`: Output<HourDetailsArgs>) {
        this.hourlyRecurrence = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("ssyneeknbwilbths")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("aixxeaoyihrrbfur")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the schedule.
     */
    @JvmName("vhoatdvvmiigvggr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Notification settings.
     */
    @JvmName("xkgandipaqersnkj")
    public suspend fun notificationSettings(`value`: Output<NotificationSettingsArgs>) {
        this.notificationSettings = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("frlclsxsyojmfmdi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("tbgxoxtykwjvonjy")
    public suspend fun status(`value`: Output<Either<String, EnableStatus>>) {
        this.status = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("hngtpfqexnvhpxur")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The resource ID to which the schedule belongs
     */
    @JvmName("aqweehfbedlboyhu")
    public suspend fun targetResourceId(`value`: Output<String>) {
        this.targetResourceId = value
    }

    /**
     * @param value The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
     */
    @JvmName("ojcuhmmwylxtqcnw")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
     */
    @JvmName("yeegpckjaxhamhux")
    public suspend fun timeZoneId(`value`: Output<String>) {
        this.timeZoneId = value
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("hitypeeaekmtpmjh")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value If the schedule will occur only some days of the week, specify the weekly recurrence.
     */
    @JvmName("juebqwmystkqbjdx")
    public suspend fun weeklyRecurrence(`value`: Output<WeekDetailsArgs>) {
        this.weeklyRecurrence = value
    }

    /**
     * @param value If the schedule will occur once each day of the week, specify the daily recurrence.
     */
    @JvmName("qmjqpabevtmwrxmi")
    public suspend fun dailyRecurrence(`value`: DayDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailyRecurrence = mapped
    }

    /**
     * @param argument If the schedule will occur once each day of the week, specify the daily recurrence.
     */
    @JvmName("dxmowwvherqxcjrt")
    public suspend fun dailyRecurrence(argument: suspend DayDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = DayDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dailyRecurrence = mapped
    }

    /**
     * @param value If the schedule will occur multiple times a day, specify the hourly recurrence.
     */
    @JvmName("ljeuuexgieddqkkw")
    public suspend fun hourlyRecurrence(`value`: HourDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hourlyRecurrence = mapped
    }

    /**
     * @param argument If the schedule will occur multiple times a day, specify the hourly recurrence.
     */
    @JvmName("pqhkcykrrmphxyob")
    public suspend fun hourlyRecurrence(argument: suspend HourDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = HourDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hourlyRecurrence = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("duyadpmcjcanjnnv")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("jnnrbjobplgpjwbq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the schedule.
     */
    @JvmName("ccrdaerteaixirsy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Notification settings.
     */
    @JvmName("iugihvvskafglwlk")
    public suspend fun notificationSettings(`value`: NotificationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationSettings = mapped
    }

    /**
     * @param argument Notification settings.
     */
    @JvmName("uottbclhrjgxjldd")
    public suspend
    fun notificationSettings(argument: suspend NotificationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notificationSettings = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("scnqfpilpllrswib")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("ncfrwehvfavpjosl")
    public suspend fun status(`value`: Either<String, EnableStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("gfwfjctpuycnkwdj")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("mywgbvuunbcnvrfu")
    public fun status(`value`: EnableStatus) {
        val toBeMapped = Either.ofRight<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("cbkjqjqshcdcyqev")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("whubhmudocegpisg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The resource ID to which the schedule belongs
     */
    @JvmName("rllsyaydsknsmiln")
    public suspend fun targetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceId = mapped
    }

    /**
     * @param value The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
     */
    @JvmName("tnpqtesjjctsjwkr")
    public suspend fun taskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
     */
    @JvmName("imppfmvmdcpqejmo")
    public suspend fun timeZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZoneId = mapped
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("vyfhqjwhccrnhbus")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    /**
     * @param value If the schedule will occur only some days of the week, specify the weekly recurrence.
     */
    @JvmName("wxapcasqrytcitio")
    public suspend fun weeklyRecurrence(`value`: WeekDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyRecurrence = mapped
    }

    /**
     * @param argument If the schedule will occur only some days of the week, specify the weekly recurrence.
     */
    @JvmName("mrmrhycdtxpwaikq")
    public suspend fun weeklyRecurrence(argument: suspend WeekDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WeekDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.weeklyRecurrence = mapped
    }

    internal fun build(): VirtualMachineScheduleArgs = VirtualMachineScheduleArgs(
        dailyRecurrence = dailyRecurrence,
        hourlyRecurrence = hourlyRecurrence,
        labName = labName,
        location = location,
        name = name,
        notificationSettings = notificationSettings,
        resourceGroupName = resourceGroupName,
        status = status,
        tags = tags,
        targetResourceId = targetResourceId,
        taskType = taskType,
        timeZoneId = timeZoneId,
        virtualMachineName = virtualMachineName,
        weeklyRecurrence = weeklyRecurrence,
    )
}
