@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.VirtualNetworkArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.SubnetArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.SubnetArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.SubnetOverrideArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.SubnetOverrideArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A virtual network.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### VirtualNetworks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.DevTestLab.VirtualNetwork("virtualNetwork", new()
 *     {
 *         LabName = "{labName}",
 *         Location = "{location}",
 *         Name = "{virtualNetworkName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewVirtualNetwork(ctx, "virtualNetwork", &devtestlab.VirtualNetworkArgs{
 * 			LabName:           pulumi.String("{labName}"),
 * 			Location:          pulumi.String("{location}"),
 * 			Name:              pulumi.String("{virtualNetworkName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.VirtualNetwork;
 * import com.pulumi.azurenative.devtestlab.VirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .labName("{labName}")
 *             .location("{location}")
 *             .name("{virtualNetworkName}")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:VirtualNetwork {virtualNetworkName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualnetworks/{name}
 * ```
 * @property allowedSubnets The allowed subnets of the virtual network.
 * @property description The description of the virtual network.
 * @property externalProviderResourceId The Microsoft.Network resource identifier of the virtual network.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property name The name of the virtual network.
 * @property resourceGroupName The name of the resource group.
 * @property subnetOverrides The subnet overrides of the virtual network.
 * @property tags The tags of the resource.
 */
public data class VirtualNetworkArgs(
    public val allowedSubnets: Output<List<SubnetArgs>>? = null,
    public val description: Output<String>? = null,
    public val externalProviderResourceId: Output<String>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnetOverrides: Output<List<SubnetOverrideArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.VirtualNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.VirtualNetworkArgs =
        com.pulumi.azurenative.devtestlab.VirtualNetworkArgs.builder()
            .allowedSubnets(
                allowedSubnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .externalProviderResourceId(externalProviderResourceId?.applyValue({ args0 -> args0 }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnetOverrides(
                subnetOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkArgs].
 */
@PulumiTagMarker
public class VirtualNetworkArgsBuilder internal constructor() {
    private var allowedSubnets: Output<List<SubnetArgs>>? = null

    private var description: Output<String>? = null

    private var externalProviderResourceId: Output<String>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnetOverrides: Output<List<SubnetOverrideArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The allowed subnets of the virtual network.
     */
    @JvmName("kykppjohcheeuepu")
    public suspend fun allowedSubnets(`value`: Output<List<SubnetArgs>>) {
        this.allowedSubnets = value
    }

    @JvmName("bjrwexpkhqwdmxjq")
    public suspend fun allowedSubnets(vararg values: Output<SubnetArgs>) {
        this.allowedSubnets = Output.all(values.asList())
    }

    /**
     * @param values The allowed subnets of the virtual network.
     */
    @JvmName("xvpvaxfxmhvyqvjl")
    public suspend fun allowedSubnets(values: List<Output<SubnetArgs>>) {
        this.allowedSubnets = Output.all(values)
    }

    /**
     * @param value The description of the virtual network.
     */
    @JvmName("bheqvskoelamrvpj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Microsoft.Network resource identifier of the virtual network.
     */
    @JvmName("usbhphgwtqomswwl")
    public suspend fun externalProviderResourceId(`value`: Output<String>) {
        this.externalProviderResourceId = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("sxxoivplxdasgcvr")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("ykcsckggqhykcefm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("frbmqwtbjrlbjwsy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("taggkrnibfncjymc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The subnet overrides of the virtual network.
     */
    @JvmName("bilaevxpabnxepvp")
    public suspend fun subnetOverrides(`value`: Output<List<SubnetOverrideArgs>>) {
        this.subnetOverrides = value
    }

    @JvmName("magkekxffentfuup")
    public suspend fun subnetOverrides(vararg values: Output<SubnetOverrideArgs>) {
        this.subnetOverrides = Output.all(values.asList())
    }

    /**
     * @param values The subnet overrides of the virtual network.
     */
    @JvmName("aoorgjvmwrcagpns")
    public suspend fun subnetOverrides(values: List<Output<SubnetOverrideArgs>>) {
        this.subnetOverrides = Output.all(values)
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("cpxpbbnjuxkqxhfm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The allowed subnets of the virtual network.
     */
    @JvmName("avfqsqkewcxtooki")
    public suspend fun allowedSubnets(`value`: List<SubnetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedSubnets = mapped
    }

    /**
     * @param argument The allowed subnets of the virtual network.
     */
    @JvmName("ywrflnqyricuesbo")
    public suspend fun allowedSubnets(argument: List<suspend SubnetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubnetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.allowedSubnets = mapped
    }

    /**
     * @param argument The allowed subnets of the virtual network.
     */
    @JvmName("siqfcylvenrkauog")
    public suspend fun allowedSubnets(vararg argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubnetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.allowedSubnets = mapped
    }

    /**
     * @param argument The allowed subnets of the virtual network.
     */
    @JvmName("xphkluwafnbhxsxe")
    public suspend fun allowedSubnets(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubnetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.allowedSubnets = mapped
    }

    /**
     * @param values The allowed subnets of the virtual network.
     */
    @JvmName("ccaepjtkceulfhkb")
    public suspend fun allowedSubnets(vararg values: SubnetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedSubnets = mapped
    }

    /**
     * @param value The description of the virtual network.
     */
    @JvmName("hiqfrnbmkapltaks")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Microsoft.Network resource identifier of the virtual network.
     */
    @JvmName("dhpxbqodwyxmmvii")
    public suspend fun externalProviderResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalProviderResourceId = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("ydwbupnupdbxqadp")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("cyubirqdqssfkqjs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("nvohwjcfngchjutv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("aomuiogtxscuaudk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The subnet overrides of the virtual network.
     */
    @JvmName("xaesnvfpmbpjuedr")
    public suspend fun subnetOverrides(`value`: List<SubnetOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetOverrides = mapped
    }

    /**
     * @param argument The subnet overrides of the virtual network.
     */
    @JvmName("rgneoxkdonbptwlm")
    public suspend fun subnetOverrides(argument: List<suspend SubnetOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubnetOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnetOverrides = mapped
    }

    /**
     * @param argument The subnet overrides of the virtual network.
     */
    @JvmName("sprahbelisdxmnri")
    public suspend fun subnetOverrides(
        vararg
        argument: suspend SubnetOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SubnetOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnetOverrides = mapped
    }

    /**
     * @param argument The subnet overrides of the virtual network.
     */
    @JvmName("sumomrxsdlrsgrmt")
    public suspend fun subnetOverrides(argument: suspend SubnetOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubnetOverrideArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subnetOverrides = mapped
    }

    /**
     * @param values The subnet overrides of the virtual network.
     */
    @JvmName("vasrlcyuencqqoub")
    public suspend fun subnetOverrides(vararg values: SubnetOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetOverrides = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("jahiphfcdnhpxhcv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("omyvixfmptvmyptu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VirtualNetworkArgs = VirtualNetworkArgs(
        allowedSubnets = allowedSubnets,
        description = description,
        externalProviderResourceId = externalProviderResourceId,
        labName = labName,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        subnetOverrides = subnetOverrides,
        tags = tags,
    )
}
