@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.ArmTemplateParameterPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of an Azure Resource Manager template parameter.
 * @property name The name of the template parameter.
 * @property value The value of the template parameter.
 */
public data class ArmTemplateParameterPropertiesArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.ArmTemplateParameterPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.ArmTemplateParameterPropertiesArgs =
        com.pulumi.azurenative.devtestlab.inputs.ArmTemplateParameterPropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArmTemplateParameterPropertiesArgs].
 */
@PulumiTagMarker
public class ArmTemplateParameterPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the template parameter.
     */
    @JvmName("twufhtrqttqttxqg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the template parameter.
     */
    @JvmName("eyagxylrtbrxgrey")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the template parameter.
     */
    @JvmName("kddqfaddhmcwjiua")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the template parameter.
     */
    @JvmName("qqtacuawtryokori")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ArmTemplateParameterPropertiesArgs = ArmTemplateParameterPropertiesArgs(
        name = name,
        `value` = `value`,
    )
}
