@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.DataDiskStorageTypeInfoArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.StorageType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Storage information about the data disks present in the custom image
 * @property lun Disk Lun
 * @property storageType Disk Storage Type
 */
public data class DataDiskStorageTypeInfoArgs(
    public val lun: Output<String>? = null,
    public val storageType: Output<Either<String, StorageType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.DataDiskStorageTypeInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.DataDiskStorageTypeInfoArgs =
        com.pulumi.azurenative.devtestlab.inputs.DataDiskStorageTypeInfoArgs.builder()
            .lun(lun?.applyValue({ args0 -> args0 }))
            .storageType(
                storageType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataDiskStorageTypeInfoArgs].
 */
@PulumiTagMarker
public class DataDiskStorageTypeInfoArgsBuilder internal constructor() {
    private var lun: Output<String>? = null

    private var storageType: Output<Either<String, StorageType>>? = null

    /**
     * @param value Disk Lun
     */
    @JvmName("xhgvmdfnkpnymvud")
    public suspend fun lun(`value`: Output<String>) {
        this.lun = value
    }

    /**
     * @param value Disk Storage Type
     */
    @JvmName("wjyxrxopayfluewg")
    public suspend fun storageType(`value`: Output<Either<String, StorageType>>) {
        this.storageType = value
    }

    /**
     * @param value Disk Lun
     */
    @JvmName("rxxafdjimpsgurbm")
    public suspend fun lun(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lun = mapped
    }

    /**
     * @param value Disk Storage Type
     */
    @JvmName("yrofrwxporheyrmv")
    public suspend fun storageType(`value`: Either<String, StorageType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value Disk Storage Type
     */
    @JvmName("uhrmbhyvtehpqaid")
    public fun storageType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value Disk Storage Type
     */
    @JvmName("pmrhvyuhsgoxtknc")
    public fun storageType(`value`: StorageType) {
        val toBeMapped = Either.ofRight<String, StorageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    internal fun build(): DataDiskStorageTypeInfoArgs = DataDiskStorageTypeInfoArgs(
        lun = lun,
        storageType = storageType,
    )
}
