@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.FormulaPropertiesFromVmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about a VM from which a formula is to be created.
 * @property labVmId The identifier of the VM from which a formula is to be created.
 */
public data class FormulaPropertiesFromVmArgs(
    public val labVmId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.FormulaPropertiesFromVmArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.FormulaPropertiesFromVmArgs =
        com.pulumi.azurenative.devtestlab.inputs.FormulaPropertiesFromVmArgs.builder()
            .labVmId(labVmId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FormulaPropertiesFromVmArgs].
 */
@PulumiTagMarker
public class FormulaPropertiesFromVmArgsBuilder internal constructor() {
    private var labVmId: Output<String>? = null

    /**
     * @param value The identifier of the VM from which a formula is to be created.
     */
    @JvmName("qvmagjufixnmdikg")
    public suspend fun labVmId(`value`: Output<String>) {
        this.labVmId = value
    }

    /**
     * @param value The identifier of the VM from which a formula is to be created.
     */
    @JvmName("uankmxywxfeejtts")
    public suspend fun labVmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labVmId = mapped
    }

    internal fun build(): FormulaPropertiesFromVmArgs = FormulaPropertiesFromVmArgs(
        labVmId = labVmId,
    )
}
