@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.ScheduleCreationParameterArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.EnableStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for creating a schedule.
 * @property dailyRecurrence If the schedule will occur once each day of the week, specify the daily recurrence.
 * @property hourlyRecurrence If the schedule will occur multiple times a day, specify the hourly recurrence.
 * @property name The name of the virtual machine or environment
 * @property notificationSettings Notification settings.
 * @property status The status of the schedule (i.e. Enabled, Disabled)
 * @property tags The tags of the resource.
 * @property targetResourceId The resource ID to which the schedule belongs
 * @property taskType The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
 * @property timeZoneId The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
 * @property weeklyRecurrence If the schedule will occur only some days of the week, specify the weekly recurrence.
 */
public data class ScheduleCreationParameterArgs(
    public val dailyRecurrence: Output<DayDetailsArgs>? = null,
    public val hourlyRecurrence: Output<HourDetailsArgs>? = null,
    public val name: Output<String>? = null,
    public val notificationSettings: Output<NotificationSettingsArgs>? = null,
    public val status: Output<Either<String, EnableStatus>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceId: Output<String>? = null,
    public val taskType: Output<String>? = null,
    public val timeZoneId: Output<String>? = null,
    public val weeklyRecurrence: Output<WeekDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.ScheduleCreationParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.ScheduleCreationParameterArgs =
        com.pulumi.azurenative.devtestlab.inputs.ScheduleCreationParameterArgs.builder()
            .dailyRecurrence(dailyRecurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hourlyRecurrence(hourlyRecurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notificationSettings(
                notificationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceId(targetResourceId?.applyValue({ args0 -> args0 }))
            .taskType(taskType?.applyValue({ args0 -> args0 }))
            .timeZoneId(timeZoneId?.applyValue({ args0 -> args0 }))
            .weeklyRecurrence(
                weeklyRecurrence?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ScheduleCreationParameterArgs].
 */
@PulumiTagMarker
public class ScheduleCreationParameterArgsBuilder internal constructor() {
    private var dailyRecurrence: Output<DayDetailsArgs>? = null

    private var hourlyRecurrence: Output<HourDetailsArgs>? = null

    private var name: Output<String>? = null

    private var notificationSettings: Output<NotificationSettingsArgs>? = null

    private var status: Output<Either<String, EnableStatus>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceId: Output<String>? = null

    private var taskType: Output<String>? = null

    private var timeZoneId: Output<String>? = null

    private var weeklyRecurrence: Output<WeekDetailsArgs>? = null

    /**
     * @param value If the schedule will occur once each day of the week, specify the daily recurrence.
     */
    @JvmName("tjrfvwjngbtdrivd")
    public suspend fun dailyRecurrence(`value`: Output<DayDetailsArgs>) {
        this.dailyRecurrence = value
    }

    /**
     * @param value If the schedule will occur multiple times a day, specify the hourly recurrence.
     */
    @JvmName("nunntagsyitorklk")
    public suspend fun hourlyRecurrence(`value`: Output<HourDetailsArgs>) {
        this.hourlyRecurrence = value
    }

    /**
     * @param value The name of the virtual machine or environment
     */
    @JvmName("xptilymblpqpdory")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Notification settings.
     */
    @JvmName("npcnpdflwrmpfmwe")
    public suspend fun notificationSettings(`value`: Output<NotificationSettingsArgs>) {
        this.notificationSettings = value
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("ouslbvdpruwpqfty")
    public suspend fun status(`value`: Output<Either<String, EnableStatus>>) {
        this.status = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("xrafjbhgbqevnhuh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The resource ID to which the schedule belongs
     */
    @JvmName("pnudqhxlsouosrjf")
    public suspend fun targetResourceId(`value`: Output<String>) {
        this.targetResourceId = value
    }

    /**
     * @param value The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
     */
    @JvmName("kqsyckfnvvbbgnot")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
     */
    @JvmName("mqolnpvopnoudyxs")
    public suspend fun timeZoneId(`value`: Output<String>) {
        this.timeZoneId = value
    }

    /**
     * @param value If the schedule will occur only some days of the week, specify the weekly recurrence.
     */
    @JvmName("ocxccqnipwnajlwq")
    public suspend fun weeklyRecurrence(`value`: Output<WeekDetailsArgs>) {
        this.weeklyRecurrence = value
    }

    /**
     * @param value If the schedule will occur once each day of the week, specify the daily recurrence.
     */
    @JvmName("iontavpfphjqkotv")
    public suspend fun dailyRecurrence(`value`: DayDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailyRecurrence = mapped
    }

    /**
     * @param argument If the schedule will occur once each day of the week, specify the daily recurrence.
     */
    @JvmName("nypjukqhekwittbx")
    public suspend fun dailyRecurrence(argument: suspend DayDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = DayDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dailyRecurrence = mapped
    }

    /**
     * @param value If the schedule will occur multiple times a day, specify the hourly recurrence.
     */
    @JvmName("fioqsklwnyawnxfm")
    public suspend fun hourlyRecurrence(`value`: HourDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hourlyRecurrence = mapped
    }

    /**
     * @param argument If the schedule will occur multiple times a day, specify the hourly recurrence.
     */
    @JvmName("rquumhafbtbwhtts")
    public suspend fun hourlyRecurrence(argument: suspend HourDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = HourDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hourlyRecurrence = mapped
    }

    /**
     * @param value The name of the virtual machine or environment
     */
    @JvmName("mmqsjplxwaligpno")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Notification settings.
     */
    @JvmName("riiwghodykkoraoy")
    public suspend fun notificationSettings(`value`: NotificationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationSettings = mapped
    }

    /**
     * @param argument Notification settings.
     */
    @JvmName("bgvmkdrdxcrjtusl")
    public suspend
    fun notificationSettings(argument: suspend NotificationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notificationSettings = mapped
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("jhvtnsgqdheuvpsd")
    public suspend fun status(`value`: Either<String, EnableStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("lbsqgvrblredevai")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the schedule (i.e. Enabled, Disabled)
     */
    @JvmName("lgtkhromnklablbq")
    public fun status(`value`: EnableStatus) {
        val toBeMapped = Either.ofRight<String, EnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("snowehmohahvdmgh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("noorwgpqvpxwdpsd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The resource ID to which the schedule belongs
     */
    @JvmName("ckamdanfscovrdrh")
    public suspend fun targetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceId = mapped
    }

    /**
     * @param value The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
     */
    @JvmName("aphdceojeovtqiib")
    public suspend fun taskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value The time zone ID (e.g. China Standard Time, Greenland Standard Time, Pacific Standard time, etc.). The possible values for this property can be found in `IReadOnlyCollection<string> TimeZoneConverter.TZConvert.KnownWindowsTimeZoneIds` (https://github.com/mattjohnsonpint/TimeZoneConverter/blob/main/README.md)
     */
    @JvmName("twufnxlmtwmprpdg")
    public suspend fun timeZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZoneId = mapped
    }

    /**
     * @param value If the schedule will occur only some days of the week, specify the weekly recurrence.
     */
    @JvmName("kbeoymhfwssqmpea")
    public suspend fun weeklyRecurrence(`value`: WeekDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyRecurrence = mapped
    }

    /**
     * @param argument If the schedule will occur only some days of the week, specify the weekly recurrence.
     */
    @JvmName("xmqbxamwbwduagmw")
    public suspend fun weeklyRecurrence(argument: suspend WeekDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WeekDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.weeklyRecurrence = mapped
    }

    internal fun build(): ScheduleCreationParameterArgs = ScheduleCreationParameterArgs(
        dailyRecurrence = dailyRecurrence,
        hourlyRecurrence = hourlyRecurrence,
        name = name,
        notificationSettings = notificationSettings,
        status = status,
        tags = tags,
        targetResourceId = targetResourceId,
        taskType = taskType,
        timeZoneId = timeZoneId,
        weeklyRecurrence = weeklyRecurrence,
    )
}
