@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.SubnetArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.UsagePermissionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Subnet information.
 * @property allowPublicIp The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
 * @property labSubnetName The name of the subnet as seen in the lab.
 * @property resourceId The resource ID of the subnet.
 */
public data class SubnetArgs(
    public val allowPublicIp: Output<Either<String, UsagePermissionType>>? = null,
    public val labSubnetName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.SubnetArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.SubnetArgs =
        com.pulumi.azurenative.devtestlab.inputs.SubnetArgs.builder()
            .allowPublicIp(
                allowPublicIp?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .labSubnetName(labSubnetName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetArgs].
 */
@PulumiTagMarker
public class SubnetArgsBuilder internal constructor() {
    private var allowPublicIp: Output<Either<String, UsagePermissionType>>? = null

    private var labSubnetName: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
     */
    @JvmName("cwbjwssvqthyetwd")
    public suspend fun allowPublicIp(`value`: Output<Either<String, UsagePermissionType>>) {
        this.allowPublicIp = value
    }

    /**
     * @param value The name of the subnet as seen in the lab.
     */
    @JvmName("heiuygerdibthtlm")
    public suspend fun labSubnetName(`value`: Output<String>) {
        this.labSubnetName = value
    }

    /**
     * @param value The resource ID of the subnet.
     */
    @JvmName("ovxpdftxpbjbtueh")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
     */
    @JvmName("bcqcmpmsgnlhuefy")
    public suspend fun allowPublicIp(`value`: Either<String, UsagePermissionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowPublicIp = mapped
    }

    /**
     * @param value The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
     */
    @JvmName("jbbnlcknlmnddwrd")
    public fun allowPublicIp(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UsagePermissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowPublicIp = mapped
    }

    /**
     * @param value The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
     */
    @JvmName("frnmbpinarvrknnm")
    public fun allowPublicIp(`value`: UsagePermissionType) {
        val toBeMapped = Either.ofRight<String, UsagePermissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowPublicIp = mapped
    }

    /**
     * @param value The name of the subnet as seen in the lab.
     */
    @JvmName("gvrgleqgnriupjve")
    public suspend fun labSubnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labSubnetName = mapped
    }

    /**
     * @param value The resource ID of the subnet.
     */
    @JvmName("biyyfcortgdlvyax")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): SubnetArgs = SubnetArgs(
        allowPublicIp = allowPublicIp,
        labSubnetName = labSubnetName,
        resourceId = resourceId,
    )
}
