@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties for creating a custom image from a virtual machine.
 * @property linuxOsInfo The Linux OS information of the VM.
 * @property sourceVmId The source vm identifier.
 * @property windowsOsInfo The Windows OS information of the VM.
 */
public data class CustomImagePropertiesFromVmResponse(
    public val linuxOsInfo: LinuxOsInfoResponse? = null,
    public val sourceVmId: String? = null,
    public val windowsOsInfo: WindowsOsInfoResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.CustomImagePropertiesFromVmResponse):
            CustomImagePropertiesFromVmResponse = CustomImagePropertiesFromVmResponse(
            linuxOsInfo = javaType.linuxOsInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.LinuxOsInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceVmId = javaType.sourceVmId().map({ args0 -> args0 }).orElse(null),
            windowsOsInfo = javaType.windowsOsInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devtestlab.kotlin.outputs.WindowsOsInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
