@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Storage information about the data disks present in the custom image
 * @property lun Disk Lun
 * @property storageType Disk Storage Type
 */
public data class DataDiskStorageTypeInfoResponse(
    public val lun: String? = null,
    public val storageType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.DataDiskStorageTypeInfoResponse):
            DataDiskStorageTypeInfoResponse = DataDiskStorageTypeInfoResponse(
            lun = javaType.lun().map({ args0 -> args0 }).orElse(null),
            storageType = javaType.storageType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
