@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load balancer.
 * @property backendPort The port to which the external traffic will be redirected.
 * @property frontendPort The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
 * @property transportProtocol The transport protocol for the endpoint.
 */
public data class InboundNatRuleResponse(
    public val backendPort: Int? = null,
    public val frontendPort: Int? = null,
    public val transportProtocol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.InboundNatRuleResponse):
            InboundNatRuleResponse = InboundNatRuleResponse(
            backendPort = javaType.backendPort().map({ args0 -> args0 }).orElse(null),
            frontendPort = javaType.frontendPort().map({ args0 -> args0 }).orElse(null),
            transportProtocol = javaType.transportProtocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
