@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of a lab's support banner
 * @property enabled Is the lab support banner active/enabled at this time?
 * @property markdown The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
 */
public data class LabSupportPropertiesResponse(
    public val enabled: String? = null,
    public val markdown: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.LabSupportPropertiesResponse):
            LabSupportPropertiesResponse = LabSupportPropertiesResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            markdown = javaType.markdown().map({ args0 -> args0 }).orElse(null),
        )
    }
}
