@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Configuration for public IP address sharing.
 * @property allowedPorts Backend ports that virtual machines on this subnet are allowed to expose
 */
public data class SubnetSharedPublicIpAddressConfigurationResponse(
    public val allowedPorts: List<PortResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devtestlab.outputs.SubnetSharedPublicIpAddressConfigurationResponse):
            SubnetSharedPublicIpAddressConfigurationResponse =
            SubnetSharedPublicIpAddressConfigurationResponse(
                allowedPorts = javaType.allowedPorts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.devtestlab.kotlin.outputs.PortResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
