@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin

import com.pulumi.azurenative.digitaltwins.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.digitaltwins.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DigitalTwinsEndpoint].
 */
@PulumiTagMarker
public class DigitalTwinsEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DigitalTwinsEndpointArgs = DigitalTwinsEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DigitalTwinsEndpointArgsBuilder.() -> Unit) {
        val builder = DigitalTwinsEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DigitalTwinsEndpoint {
        val builtJavaResource =
            com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DigitalTwinsEndpoint(builtJavaResource)
    }
}

/**
 * DigitalTwinsInstance endpoint resource.
 * Azure REST API version: 2023-01-31. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-03-01-preview.
 * ## Example Usage
 * ### Put a DigitalTwinsEndpoint resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var digitalTwinsEndpoint = new AzureNative.DigitalTwins.DigitalTwinsEndpoint("digitalTwinsEndpoint", new()
 *     {
 *         EndpointName = "myServiceBus",
 *         Properties = new AzureNative.DigitalTwins.Inputs.ServiceBusArgs
 *         {
 *             AuthenticationType = "KeyBased",
 *             EndpointType = "ServiceBus",
 *             PrimaryConnectionString = "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc",
 *             SecondaryConnectionString = "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc",
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewDigitalTwinsEndpoint(ctx, "digitalTwinsEndpoint", &digitaltwins.DigitalTwinsEndpointArgs{
 * 			EndpointName: pulumi.String("myServiceBus"),
 * 			Properties: digitaltwins.ServiceBus{
 * 				AuthenticationType:        "KeyBased",
 * 				EndpointType:              "ServiceBus",
 * 				PrimaryConnectionString:   "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc",
 * 				SecondaryConnectionString: "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc",
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myDigitalTwinsService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpoint;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var digitalTwinsEndpoint = new DigitalTwinsEndpoint("digitalTwinsEndpoint", DigitalTwinsEndpointArgs.builder()
 *             .endpointName("myServiceBus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("authenticationType", "KeyBased"),
 *                 Map.entry("endpointType", "ServiceBus"),
 *                 Map.entry("primaryConnectionString", "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc"),
 *                 Map.entry("secondaryConnectionString", "Endpoint=sb://mysb.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=xyzxyzoX4=;EntityPath=abcabc")
 *             ))
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .build());
 *     }
 * }
 * ```
 * ### Put a DigitalTwinsEndpoint resource with identity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var digitalTwinsEndpoint = new AzureNative.DigitalTwins.DigitalTwinsEndpoint("digitalTwinsEndpoint", new()
 *     {
 *         EndpointName = "myServiceBus",
 *         Properties = new AzureNative.DigitalTwins.Inputs.ServiceBusArgs
 *         {
 *             AuthenticationType = "IdentityBased",
 *             EndpointType = "ServiceBus",
 *             EndpointUri = "sb://mysb.servicebus.windows.net/",
 *             EntityPath = "mysbtopic",
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewDigitalTwinsEndpoint(ctx, "digitalTwinsEndpoint", &digitaltwins.DigitalTwinsEndpointArgs{
 * 			EndpointName: pulumi.String("myServiceBus"),
 * 			Properties: digitaltwins.ServiceBus{
 * 				AuthenticationType: "IdentityBased",
 * 				EndpointType:       "ServiceBus",
 * 				EndpointUri:        "sb://mysb.servicebus.windows.net/",
 * 				EntityPath:         "mysbtopic",
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myDigitalTwinsService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpoint;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var digitalTwinsEndpoint = new DigitalTwinsEndpoint("digitalTwinsEndpoint", DigitalTwinsEndpointArgs.builder()
 *             .endpointName("myServiceBus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("authenticationType", "IdentityBased"),
 *                 Map.entry("endpointType", "ServiceBus"),
 *                 Map.entry("endpointUri", "sb://mysb.servicebus.windows.net/"),
 *                 Map.entry("entityPath", "mysbtopic")
 *             ))
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .build());
 *     }
 * }
 * ```
 * ### Put a DigitalTwinsEndpoint resource with user assigned identity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var digitalTwinsEndpoint = new AzureNative.DigitalTwins.DigitalTwinsEndpoint("digitalTwinsEndpoint", new()
 *     {
 *         EndpointName = "myServiceBus",
 *         Properties = new AzureNative.DigitalTwins.Inputs.ServiceBusArgs
 *         {
 *             AuthenticationType = "IdentityBased",
 *             EndpointType = "ServiceBus",
 *             EndpointUri = "sb://mysb.servicebus.windows.net/",
 *             EntityPath = "mysbtopic",
 *             Identity = new AzureNative.DigitalTwins.Inputs.ManagedIdentityReferenceArgs
 *             {
 *                 Type = "UserAssigned",
 *                 UserAssignedIdentity = "/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity",
 *             },
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := digitaltwins.NewDigitalTwinsEndpoint(ctx, "digitalTwinsEndpoint", &digitaltwins.DigitalTwinsEndpointArgs{
 * 			EndpointName: pulumi.String("myServiceBus"),
 * 			Properties: digitaltwins.ServiceBus{
 * 				AuthenticationType: "IdentityBased",
 * 				EndpointType:       "ServiceBus",
 * 				EndpointUri:        "sb://mysb.servicebus.windows.net/",
 * 				EntityPath:         "mysbtopic",
 * 				Identity: digitaltwins.ManagedIdentityReference{
 * 					Type:                 "UserAssigned",
 * 					UserAssignedIdentity: "/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myDigitalTwinsService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpoint;
 * import com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var digitalTwinsEndpoint = new DigitalTwinsEndpoint("digitalTwinsEndpoint", DigitalTwinsEndpointArgs.builder()
 *             .endpointName("myServiceBus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("authenticationType", "IdentityBased"),
 *                 Map.entry("endpointType", "ServiceBus"),
 *                 Map.entry("endpointUri", "sb://mysb.servicebus.windows.net/"),
 *                 Map.entry("entityPath", "mysbtopic"),
 *                 Map.entry("identity", Map.ofEntries(
 *                     Map.entry("type", "UserAssigned"),
 *                     Map.entry("userAssignedIdentity", "/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity")
 *                 ))
 *             ))
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:digitaltwins:DigitalTwinsEndpoint myServiceBus /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DigitalTwins/digitalTwinsInstances/{resourceName}/endpoints/{endpointName}
 * ```
 */
public class DigitalTwinsEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpoint,
) : KotlinCustomResource(javaResource, DigitalTwinsEndpointMapper) {
    /**
     * Extension resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * DigitalTwinsInstance endpoint resource properties.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DigitalTwinsEndpointMapper : ResourceMapper<DigitalTwinsEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): DigitalTwinsEndpoint = DigitalTwinsEndpoint(
        javaResource
            as com.pulumi.azurenative.digitaltwins.DigitalTwinsEndpoint,
    )
}

/**
 * @see [DigitalTwinsEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DigitalTwinsEndpoint].
 */
public suspend fun digitalTwinsEndpoint(
    name: String,
    block: suspend DigitalTwinsEndpointResourceBuilder.() -> Unit,
): DigitalTwinsEndpoint {
    val builder = DigitalTwinsEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DigitalTwinsEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun digitalTwinsEndpoint(name: String): DigitalTwinsEndpoint {
    val builder = DigitalTwinsEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
