@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin

import com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnectionArgs.builder
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.AzureDataExplorerConnectionPropertiesArgs
import com.pulumi.azurenative.digitaltwins.kotlin.inputs.AzureDataExplorerConnectionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a time series database connection resource.
 * Azure REST API version: 2023-01-31. Prior API version in Azure Native 1.x: 2021-06-30-preview.
 * ## Example Usage
 * ### Create or replace a time series database connection for a DigitalTwins instance with user assigned identity.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var timeSeriesDatabaseConnection = new AzureNative.DigitalTwins.TimeSeriesDatabaseConnection("timeSeriesDatabaseConnection", new()
 *     {
 *         Properties = new AzureNative.DigitalTwins.Inputs.AzureDataExplorerConnectionPropertiesArgs
 *         {
 *             AdxDatabaseName = "myDatabase",
 *             AdxEndpointUri = "https://mycluster.kusto.windows.net",
 *             AdxResourceId = "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster",
 *             AdxTableName = "myTable",
 *             ConnectionType = "AzureDataExplorer",
 *             EventHubEndpointUri = "sb://myeh.servicebus.windows.net/",
 *             EventHubEntityPath = "myeh",
 *             EventHubNamespaceResourceId = "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh",
 *             Identity = new AzureNative.DigitalTwins.Inputs.ManagedIdentityReferenceArgs
 *             {
 *                 Type = "UserAssigned",
 *                 UserAssignedIdentity = "/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity",
 *             },
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *         TimeSeriesDatabaseConnectionName = "myConnection",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := digitaltwins.NewTimeSeriesDatabaseConnection(ctx, "timeSeriesDatabaseConnection", &digitaltwins.TimeSeriesDatabaseConnectionArgs{
 * Properties: interface{}{
 * AdxDatabaseName: pulumi.String("myDatabase"),
 * AdxEndpointUri: pulumi.String("https://mycluster.kusto.windows.net"),
 * AdxResourceId: pulumi.String("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
 * AdxTableName: pulumi.String("myTable"),
 * ConnectionType: pulumi.String("AzureDataExplorer"),
 * EventHubEndpointUri: pulumi.String("sb://myeh.servicebus.windows.net/"),
 * EventHubEntityPath: pulumi.String("myeh"),
 * EventHubNamespaceResourceId: pulumi.String("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
 * Identity: &digitaltwins.ManagedIdentityReferenceArgs{
 * Type: pulumi.String("UserAssigned"),
 * UserAssignedIdentity: pulumi.String("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity"),
 * },
 * },
 * ResourceGroupName: pulumi.String("resRg"),
 * ResourceName: pulumi.String("myDigitalTwinsService"),
 * TimeSeriesDatabaseConnectionName: pulumi.String("myConnection"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnection;
 * import com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var timeSeriesDatabaseConnection = new TimeSeriesDatabaseConnection("timeSeriesDatabaseConnection", TimeSeriesDatabaseConnectionArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("adxDatabaseName", "myDatabase"),
 *                 Map.entry("adxEndpointUri", "https://mycluster.kusto.windows.net"),
 *                 Map.entry("adxResourceId", "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
 *                 Map.entry("adxTableName", "myTable"),
 *                 Map.entry("connectionType", "AzureDataExplorer"),
 *                 Map.entry("eventHubEndpointUri", "sb://myeh.servicebus.windows.net/"),
 *                 Map.entry("eventHubEntityPath", "myeh"),
 *                 Map.entry("eventHubNamespaceResourceId", "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
 *                 Map.entry("identity", Map.ofEntries(
 *                     Map.entry("type", "UserAssigned"),
 *                     Map.entry("userAssignedIdentity", "/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity")
 *                 ))
 *             ))
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .timeSeriesDatabaseConnectionName("myConnection")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or replace a time series database connection for a DigitalTwins instance.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var timeSeriesDatabaseConnection = new AzureNative.DigitalTwins.TimeSeriesDatabaseConnection("timeSeriesDatabaseConnection", new()
 *     {
 *         Properties = new AzureNative.DigitalTwins.Inputs.AzureDataExplorerConnectionPropertiesArgs
 *         {
 *             AdxDatabaseName = "myDatabase",
 *             AdxEndpointUri = "https://mycluster.kusto.windows.net",
 *             AdxRelationshipLifecycleEventsTableName = "myRelationshipLifecycleEventsTable",
 *             AdxResourceId = "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster",
 *             AdxTableName = "myPropertyUpdatesTable",
 *             AdxTwinLifecycleEventsTableName = "myTwinLifecycleEventsTable",
 *             ConnectionType = "AzureDataExplorer",
 *             EventHubEndpointUri = "sb://myeh.servicebus.windows.net/",
 *             EventHubEntityPath = "myeh",
 *             EventHubNamespaceResourceId = "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh",
 *             RecordPropertyAndItemRemovals = "true",
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myDigitalTwinsService",
 *         TimeSeriesDatabaseConnectionName = "myConnection",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/digitaltwins/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := digitaltwins.NewTimeSeriesDatabaseConnection(ctx, "timeSeriesDatabaseConnection", &digitaltwins.TimeSeriesDatabaseConnectionArgs{
 * Properties: interface{}{
 * AdxDatabaseName: pulumi.String("myDatabase"),
 * AdxEndpointUri: pulumi.String("https://mycluster.kusto.windows.net"),
 * AdxRelationshipLifecycleEventsTableName: pulumi.String("myRelationshipLifecycleEventsTable"),
 * AdxResourceId: pulumi.String("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
 * AdxTableName: pulumi.String("myPropertyUpdatesTable"),
 * AdxTwinLifecycleEventsTableName: pulumi.String("myTwinLifecycleEventsTable"),
 * ConnectionType: pulumi.String("AzureDataExplorer"),
 * EventHubEndpointUri: pulumi.String("sb://myeh.servicebus.windows.net/"),
 * EventHubEntityPath: pulumi.String("myeh"),
 * EventHubNamespaceResourceId: pulumi.String("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
 * RecordPropertyAndItemRemovals: pulumi.String("true"),
 * },
 * ResourceGroupName: pulumi.String("resRg"),
 * ResourceName: pulumi.String("myDigitalTwinsService"),
 * TimeSeriesDatabaseConnectionName: pulumi.String("myConnection"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnection;
 * import com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var timeSeriesDatabaseConnection = new TimeSeriesDatabaseConnection("timeSeriesDatabaseConnection", TimeSeriesDatabaseConnectionArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("adxDatabaseName", "myDatabase"),
 *                 Map.entry("adxEndpointUri", "https://mycluster.kusto.windows.net"),
 *                 Map.entry("adxRelationshipLifecycleEventsTableName", "myRelationshipLifecycleEventsTable"),
 *                 Map.entry("adxResourceId", "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"),
 *                 Map.entry("adxTableName", "myPropertyUpdatesTable"),
 *                 Map.entry("adxTwinLifecycleEventsTableName", "myTwinLifecycleEventsTable"),
 *                 Map.entry("connectionType", "AzureDataExplorer"),
 *                 Map.entry("eventHubEndpointUri", "sb://myeh.servicebus.windows.net/"),
 *                 Map.entry("eventHubEntityPath", "myeh"),
 *                 Map.entry("eventHubNamespaceResourceId", "/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"),
 *                 Map.entry("recordPropertyAndItemRemovals", "true")
 *             ))
 *             .resourceGroupName("resRg")
 *             .resourceName("myDigitalTwinsService")
 *             .timeSeriesDatabaseConnectionName("myConnection")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:digitaltwins:TimeSeriesDatabaseConnection myConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DigitalTwins/digitalTwinsInstances/{resourceName}/timeSeriesDatabaseConnections/{timeSeriesDatabaseConnectionName}
 * ```
 * @property properties Properties of a specific time series database connection.
 * @property resourceGroupName The name of the resource group that contains the DigitalTwinsInstance.
 * @property resourceName The name of the DigitalTwinsInstance.
 * @property timeSeriesDatabaseConnectionName Name of time series database connection.
 */
public data class TimeSeriesDatabaseConnectionArgs(
    public val properties: Output<AzureDataExplorerConnectionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val timeSeriesDatabaseConnectionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnectionArgs =
        com.pulumi.azurenative.digitaltwins.TimeSeriesDatabaseConnectionArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .timeSeriesDatabaseConnectionName(
                timeSeriesDatabaseConnectionName?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [TimeSeriesDatabaseConnectionArgs].
 */
@PulumiTagMarker
public class TimeSeriesDatabaseConnectionArgsBuilder internal constructor() {
    private var properties: Output<AzureDataExplorerConnectionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var timeSeriesDatabaseConnectionName: Output<String>? = null

    /**
     * @param value Properties of a specific time series database connection.
     */
    @JvmName("xwdrvmtwnfyqtfii")
    public suspend fun properties(`value`: Output<AzureDataExplorerConnectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the DigitalTwinsInstance.
     */
    @JvmName("phanfmilccfmfyaf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the DigitalTwinsInstance.
     */
    @JvmName("cdhqaclmmdtwatxe")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Name of time series database connection.
     */
    @JvmName("dwjbmkesldcndpsc")
    public suspend fun timeSeriesDatabaseConnectionName(`value`: Output<String>) {
        this.timeSeriesDatabaseConnectionName = value
    }

    /**
     * @param value Properties of a specific time series database connection.
     */
    @JvmName("tgsaegsnhmdpvufw")
    public suspend fun properties(`value`: AzureDataExplorerConnectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of a specific time series database connection.
     */
    @JvmName("ycumygtybquvutnm")
    public suspend
    fun properties(argument: suspend AzureDataExplorerConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AzureDataExplorerConnectionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the DigitalTwinsInstance.
     */
    @JvmName("qpxvhbvgayrtttht")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the DigitalTwinsInstance.
     */
    @JvmName("hrdnrpwycdfpuhiq")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Name of time series database connection.
     */
    @JvmName("xhgpfphsrigdgsmq")
    public suspend fun timeSeriesDatabaseConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSeriesDatabaseConnectionName = mapped
    }

    internal fun build(): TimeSeriesDatabaseConnectionArgs = TimeSeriesDatabaseConnectionArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        timeSeriesDatabaseConnectionName = timeSeriesDatabaseConnectionName,
    )
}
