@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.inputs

import com.pulumi.azurenative.digitaltwins.inputs.AzureDataExplorerConnectionPropertiesArgs.builder
import com.pulumi.azurenative.digitaltwins.kotlin.enums.RecordPropertyAndItemRemovals
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of a time series database connection to Azure Data Explorer with data being sent via an EventHub.
 * @property adxDatabaseName The name of the Azure Data Explorer database.
 * @property adxEndpointUri The URI of the Azure Data Explorer endpoint.
 * @property adxRelationshipLifecycleEventsTableName The name of the Azure Data Explorer table used for recording relationship lifecycle events. The table will not be created if this property is left unspecified.
 * @property adxResourceId The resource ID of the Azure Data Explorer cluster.
 * @property adxTableName The name of the Azure Data Explorer table used for storing updates to properties of twins and relationships. Defaults to AdtPropertyEvents.
 * @property adxTwinLifecycleEventsTableName The name of the Azure Data Explorer table used for recording twin lifecycle events. The table will not be created if this property is left unspecified.
 * @property connectionType The type of time series connection resource.
 * Expected value is 'AzureDataExplorer'.
 * @property eventHubConsumerGroup The EventHub consumer group to use when ADX reads from EventHub. Defaults to $Default.
 * @property eventHubEndpointUri The URL of the EventHub namespace for identity-based authentication. It must include the protocol sb://
 * @property eventHubEntityPath The EventHub name in the EventHub namespace for identity-based authentication.
 * @property eventHubNamespaceResourceId The resource ID of the EventHub namespace.
 * @property identity Managed identity properties for the time series database connection resource.
 * @property recordPropertyAndItemRemovals Specifies whether or not to record twin / relationship property and item removals, including removals of indexed or keyed values (such as map entries, array elements, etc.). This feature is de-activated unless explicitly set to 'true'. Setting this property to 'true' will generate an additional column in the property events table in ADX.
 */
public data class AzureDataExplorerConnectionPropertiesArgs(
    public val adxDatabaseName: Output<String>,
    public val adxEndpointUri: Output<String>,
    public val adxRelationshipLifecycleEventsTableName: Output<String>? = null,
    public val adxResourceId: Output<String>,
    public val adxTableName: Output<String>? = null,
    public val adxTwinLifecycleEventsTableName: Output<String>? = null,
    public val connectionType: Output<String>,
    public val eventHubConsumerGroup: Output<String>? = null,
    public val eventHubEndpointUri: Output<String>,
    public val eventHubEntityPath: Output<String>,
    public val eventHubNamespaceResourceId: Output<String>,
    public val identity: Output<ManagedIdentityReferenceArgs>? = null,
    public val recordPropertyAndItemRemovals: Output<Either<String, RecordPropertyAndItemRemovals>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.digitaltwins.inputs.AzureDataExplorerConnectionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.digitaltwins.inputs.AzureDataExplorerConnectionPropertiesArgs =
        com.pulumi.azurenative.digitaltwins.inputs.AzureDataExplorerConnectionPropertiesArgs.builder()
            .adxDatabaseName(adxDatabaseName.applyValue({ args0 -> args0 }))
            .adxEndpointUri(adxEndpointUri.applyValue({ args0 -> args0 }))
            .adxRelationshipLifecycleEventsTableName(
                adxRelationshipLifecycleEventsTableName?.applyValue({ args0 ->
                    args0
                }),
            )
            .adxResourceId(adxResourceId.applyValue({ args0 -> args0 }))
            .adxTableName(adxTableName?.applyValue({ args0 -> args0 }))
            .adxTwinLifecycleEventsTableName(adxTwinLifecycleEventsTableName?.applyValue({ args0 -> args0 }))
            .connectionType(connectionType.applyValue({ args0 -> args0 }))
            .eventHubConsumerGroup(eventHubConsumerGroup?.applyValue({ args0 -> args0 }))
            .eventHubEndpointUri(eventHubEndpointUri.applyValue({ args0 -> args0 }))
            .eventHubEntityPath(eventHubEntityPath.applyValue({ args0 -> args0 }))
            .eventHubNamespaceResourceId(eventHubNamespaceResourceId.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recordPropertyAndItemRemovals(
                recordPropertyAndItemRemovals?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [AzureDataExplorerConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class AzureDataExplorerConnectionPropertiesArgsBuilder internal constructor() {
    private var adxDatabaseName: Output<String>? = null

    private var adxEndpointUri: Output<String>? = null

    private var adxRelationshipLifecycleEventsTableName: Output<String>? = null

    private var adxResourceId: Output<String>? = null

    private var adxTableName: Output<String>? = null

    private var adxTwinLifecycleEventsTableName: Output<String>? = null

    private var connectionType: Output<String>? = null

    private var eventHubConsumerGroup: Output<String>? = null

    private var eventHubEndpointUri: Output<String>? = null

    private var eventHubEntityPath: Output<String>? = null

    private var eventHubNamespaceResourceId: Output<String>? = null

    private var identity: Output<ManagedIdentityReferenceArgs>? = null

    private var recordPropertyAndItemRemovals: Output<Either<String, RecordPropertyAndItemRemovals>>? =
        null

    /**
     * @param value The name of the Azure Data Explorer database.
     */
    @JvmName("qbarlbgvdiqykxby")
    public suspend fun adxDatabaseName(`value`: Output<String>) {
        this.adxDatabaseName = value
    }

    /**
     * @param value The URI of the Azure Data Explorer endpoint.
     */
    @JvmName("jrbbiocoavtxrrmw")
    public suspend fun adxEndpointUri(`value`: Output<String>) {
        this.adxEndpointUri = value
    }

    /**
     * @param value The name of the Azure Data Explorer table used for recording relationship lifecycle events. The table will not be created if this property is left unspecified.
     */
    @JvmName("dnlsegljfhvxtkqk")
    public suspend fun adxRelationshipLifecycleEventsTableName(`value`: Output<String>) {
        this.adxRelationshipLifecycleEventsTableName = value
    }

    /**
     * @param value The resource ID of the Azure Data Explorer cluster.
     */
    @JvmName("gmiavparrmgtrvtt")
    public suspend fun adxResourceId(`value`: Output<String>) {
        this.adxResourceId = value
    }

    /**
     * @param value The name of the Azure Data Explorer table used for storing updates to properties of twins and relationships. Defaults to AdtPropertyEvents.
     */
    @JvmName("ygiqdheooounonak")
    public suspend fun adxTableName(`value`: Output<String>) {
        this.adxTableName = value
    }

    /**
     * @param value The name of the Azure Data Explorer table used for recording twin lifecycle events. The table will not be created if this property is left unspecified.
     */
    @JvmName("nyuxwnxqsovkrhlk")
    public suspend fun adxTwinLifecycleEventsTableName(`value`: Output<String>) {
        this.adxTwinLifecycleEventsTableName = value
    }

    /**
     * @param value The type of time series connection resource.
     * Expected value is 'AzureDataExplorer'.
     */
    @JvmName("bxuvljwqiupbepao")
    public suspend fun connectionType(`value`: Output<String>) {
        this.connectionType = value
    }

    /**
     * @param value The EventHub consumer group to use when ADX reads from EventHub. Defaults to $Default.
     */
    @JvmName("nfxqsykevqolnlyc")
    public suspend fun eventHubConsumerGroup(`value`: Output<String>) {
        this.eventHubConsumerGroup = value
    }

    /**
     * @param value The URL of the EventHub namespace for identity-based authentication. It must include the protocol sb://
     */
    @JvmName("tfeccjoqvisemvmx")
    public suspend fun eventHubEndpointUri(`value`: Output<String>) {
        this.eventHubEndpointUri = value
    }

    /**
     * @param value The EventHub name in the EventHub namespace for identity-based authentication.
     */
    @JvmName("dudumkvinsxxwxub")
    public suspend fun eventHubEntityPath(`value`: Output<String>) {
        this.eventHubEntityPath = value
    }

    /**
     * @param value The resource ID of the EventHub namespace.
     */
    @JvmName("dgncuerhsbxpwrkl")
    public suspend fun eventHubNamespaceResourceId(`value`: Output<String>) {
        this.eventHubNamespaceResourceId = value
    }

    /**
     * @param value Managed identity properties for the time series database connection resource.
     */
    @JvmName("oxmoptjbpstpiybj")
    public suspend fun identity(`value`: Output<ManagedIdentityReferenceArgs>) {
        this.identity = value
    }

    /**
     * @param value Specifies whether or not to record twin / relationship property and item removals, including removals of indexed or keyed values (such as map entries, array elements, etc.). This feature is de-activated unless explicitly set to 'true'. Setting this property to 'true' will generate an additional column in the property events table in ADX.
     */
    @JvmName("fllfhtlbadsqvbii")
    public suspend
    fun recordPropertyAndItemRemovals(`value`: Output<Either<String, RecordPropertyAndItemRemovals>>) {
        this.recordPropertyAndItemRemovals = value
    }

    /**
     * @param value The name of the Azure Data Explorer database.
     */
    @JvmName("xnwiajymxkeushqu")
    public suspend fun adxDatabaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adxDatabaseName = mapped
    }

    /**
     * @param value The URI of the Azure Data Explorer endpoint.
     */
    @JvmName("yrmpmuerktwhmlms")
    public suspend fun adxEndpointUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adxEndpointUri = mapped
    }

    /**
     * @param value The name of the Azure Data Explorer table used for recording relationship lifecycle events. The table will not be created if this property is left unspecified.
     */
    @JvmName("tacnieekmfmscxmk")
    public suspend fun adxRelationshipLifecycleEventsTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adxRelationshipLifecycleEventsTableName = mapped
    }

    /**
     * @param value The resource ID of the Azure Data Explorer cluster.
     */
    @JvmName("immabrpiyubocegf")
    public suspend fun adxResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adxResourceId = mapped
    }

    /**
     * @param value The name of the Azure Data Explorer table used for storing updates to properties of twins and relationships. Defaults to AdtPropertyEvents.
     */
    @JvmName("bgstfaymwfurjusj")
    public suspend fun adxTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adxTableName = mapped
    }

    /**
     * @param value The name of the Azure Data Explorer table used for recording twin lifecycle events. The table will not be created if this property is left unspecified.
     */
    @JvmName("yhlrjeiteomsfrht")
    public suspend fun adxTwinLifecycleEventsTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adxTwinLifecycleEventsTableName = mapped
    }

    /**
     * @param value The type of time series connection resource.
     * Expected value is 'AzureDataExplorer'.
     */
    @JvmName("hankxlcbaplfsvwg")
    public suspend fun connectionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param value The EventHub consumer group to use when ADX reads from EventHub. Defaults to $Default.
     */
    @JvmName("nqenehkgwqtgqvxh")
    public suspend fun eventHubConsumerGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubConsumerGroup = mapped
    }

    /**
     * @param value The URL of the EventHub namespace for identity-based authentication. It must include the protocol sb://
     */
    @JvmName("uejpsbtqpfsddpsn")
    public suspend fun eventHubEndpointUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubEndpointUri = mapped
    }

    /**
     * @param value The EventHub name in the EventHub namespace for identity-based authentication.
     */
    @JvmName("xfxycbougxmydxum")
    public suspend fun eventHubEntityPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubEntityPath = mapped
    }

    /**
     * @param value The resource ID of the EventHub namespace.
     */
    @JvmName("osiyrfkxlvoalfux")
    public suspend fun eventHubNamespaceResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubNamespaceResourceId = mapped
    }

    /**
     * @param value Managed identity properties for the time series database connection resource.
     */
    @JvmName("umyfddimruubbhyn")
    public suspend fun identity(`value`: ManagedIdentityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity properties for the time series database connection resource.
     */
    @JvmName("lcdqbywbbitxrfhg")
    public suspend fun identity(argument: suspend ManagedIdentityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Specifies whether or not to record twin / relationship property and item removals, including removals of indexed or keyed values (such as map entries, array elements, etc.). This feature is de-activated unless explicitly set to 'true'. Setting this property to 'true' will generate an additional column in the property events table in ADX.
     */
    @JvmName("qlgbybwxcgldjqtl")
    public suspend
    fun recordPropertyAndItemRemovals(`value`: Either<String, RecordPropertyAndItemRemovals>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordPropertyAndItemRemovals = mapped
    }

    /**
     * @param value Specifies whether or not to record twin / relationship property and item removals, including removals of indexed or keyed values (such as map entries, array elements, etc.). This feature is de-activated unless explicitly set to 'true'. Setting this property to 'true' will generate an additional column in the property events table in ADX.
     */
    @JvmName("elobtfnyiokobuuk")
    public fun recordPropertyAndItemRemovals(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecordPropertyAndItemRemovals>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordPropertyAndItemRemovals = mapped
    }

    /**
     * @param value Specifies whether or not to record twin / relationship property and item removals, including removals of indexed or keyed values (such as map entries, array elements, etc.). This feature is de-activated unless explicitly set to 'true'. Setting this property to 'true' will generate an additional column in the property events table in ADX.
     */
    @JvmName("ulmjabwtqjimixam")
    public fun recordPropertyAndItemRemovals(`value`: RecordPropertyAndItemRemovals) {
        val toBeMapped = Either.ofRight<String, RecordPropertyAndItemRemovals>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordPropertyAndItemRemovals = mapped
    }

    internal fun build(): AzureDataExplorerConnectionPropertiesArgs =
        AzureDataExplorerConnectionPropertiesArgs(
            adxDatabaseName = adxDatabaseName ?: throw PulumiNullFieldException("adxDatabaseName"),
            adxEndpointUri = adxEndpointUri ?: throw PulumiNullFieldException("adxEndpointUri"),
            adxRelationshipLifecycleEventsTableName = adxRelationshipLifecycleEventsTableName,
            adxResourceId = adxResourceId ?: throw PulumiNullFieldException("adxResourceId"),
            adxTableName = adxTableName,
            adxTwinLifecycleEventsTableName = adxTwinLifecycleEventsTableName,
            connectionType = connectionType ?: throw PulumiNullFieldException("connectionType"),
            eventHubConsumerGroup = eventHubConsumerGroup,
            eventHubEndpointUri = eventHubEndpointUri ?: throw PulumiNullFieldException("eventHubEndpointUri"),
            eventHubEntityPath = eventHubEntityPath ?: throw PulumiNullFieldException("eventHubEntityPath"),
            eventHubNamespaceResourceId = eventHubNamespaceResourceId ?: throw
                PulumiNullFieldException("eventHubNamespaceResourceId"),
            identity = identity,
            recordPropertyAndItemRemovals = recordPropertyAndItemRemovals,
        )
}
