@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.inputs

import com.pulumi.azurenative.digitaltwins.inputs.ServiceBusArgs.builder
import com.pulumi.azurenative.digitaltwins.kotlin.enums.AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties related to ServiceBus.
 * @property authenticationType Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
 * @property deadLetterSecret Dead letter storage secret for key-based authentication. Will be obfuscated during read.
 * @property deadLetterUri Dead letter storage URL for identity-based authentication.
 * @property endpointType The type of Digital Twins endpoint
 * Expected value is 'ServiceBus'.
 * @property endpointUri The URL of the ServiceBus namespace for identity-based authentication. It must include the protocol 'sb://'.
 * @property entityPath The ServiceBus Topic name for identity-based authentication.
 * @property identity Managed identity properties for the endpoint.
 * @property primaryConnectionString PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
 * @property secondaryConnectionString SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
 */
public data class ServiceBusArgs(
    public val authenticationType: Output<Either<String, AuthenticationType>>? = null,
    public val deadLetterSecret: Output<String>? = null,
    public val deadLetterUri: Output<String>? = null,
    public val endpointType: Output<String>,
    public val endpointUri: Output<String>? = null,
    public val entityPath: Output<String>? = null,
    public val identity: Output<ManagedIdentityReferenceArgs>? = null,
    public val primaryConnectionString: Output<String>? = null,
    public val secondaryConnectionString: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.digitaltwins.inputs.ServiceBusArgs> {
    override fun toJava(): com.pulumi.azurenative.digitaltwins.inputs.ServiceBusArgs =
        com.pulumi.azurenative.digitaltwins.inputs.ServiceBusArgs.builder()
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .deadLetterSecret(deadLetterSecret?.applyValue({ args0 -> args0 }))
            .deadLetterUri(deadLetterUri?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .endpointUri(endpointUri?.applyValue({ args0 -> args0 }))
            .entityPath(entityPath?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .primaryConnectionString(primaryConnectionString?.applyValue({ args0 -> args0 }))
            .secondaryConnectionString(secondaryConnectionString?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceBusArgs].
 */
@PulumiTagMarker
public class ServiceBusArgsBuilder internal constructor() {
    private var authenticationType: Output<Either<String, AuthenticationType>>? = null

    private var deadLetterSecret: Output<String>? = null

    private var deadLetterUri: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var endpointUri: Output<String>? = null

    private var entityPath: Output<String>? = null

    private var identity: Output<ManagedIdentityReferenceArgs>? = null

    private var primaryConnectionString: Output<String>? = null

    private var secondaryConnectionString: Output<String>? = null

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("gxwaoidqwnglbcql")
    public suspend fun authenticationType(`value`: Output<Either<String, AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value Dead letter storage secret for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("nfoaggfcwmewwlbm")
    public suspend fun deadLetterSecret(`value`: Output<String>) {
        this.deadLetterSecret = value
    }

    /**
     * @param value Dead letter storage URL for identity-based authentication.
     */
    @JvmName("onfivdencktupfwi")
    public suspend fun deadLetterUri(`value`: Output<String>) {
        this.deadLetterUri = value
    }

    /**
     * @param value The type of Digital Twins endpoint
     * Expected value is 'ServiceBus'.
     */
    @JvmName("qwdouhblbmxtxtgv")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The URL of the ServiceBus namespace for identity-based authentication. It must include the protocol 'sb://'.
     */
    @JvmName("ajvjsguhrhiuorsc")
    public suspend fun endpointUri(`value`: Output<String>) {
        this.endpointUri = value
    }

    /**
     * @param value The ServiceBus Topic name for identity-based authentication.
     */
    @JvmName("rpthceskornaofvd")
    public suspend fun entityPath(`value`: Output<String>) {
        this.entityPath = value
    }

    /**
     * @param value Managed identity properties for the endpoint.
     */
    @JvmName("onolcrydtdtyqeve")
    public suspend fun identity(`value`: Output<ManagedIdentityReferenceArgs>) {
        this.identity = value
    }

    /**
     * @param value PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("jcyedansvdflfyym")
    public suspend fun primaryConnectionString(`value`: Output<String>) {
        this.primaryConnectionString = value
    }

    /**
     * @param value SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("dialjolulnhpcfml")
    public suspend fun secondaryConnectionString(`value`: Output<String>) {
        this.secondaryConnectionString = value
    }

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("lqqkoqjcidgbqfks")
    public suspend fun authenticationType(`value`: Either<String, AuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("fmqpdwyifkgafyfr")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
     */
    @JvmName("unbokntqeedfxtbj")
    public fun authenticationType(`value`: AuthenticationType) {
        val toBeMapped = Either.ofRight<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Dead letter storage secret for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("bfmlotuxsgbtulha")
    public suspend fun deadLetterSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterSecret = mapped
    }

    /**
     * @param value Dead letter storage URL for identity-based authentication.
     */
    @JvmName("wmuhaidnmkfdpmvq")
    public suspend fun deadLetterUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterUri = mapped
    }

    /**
     * @param value The type of Digital Twins endpoint
     * Expected value is 'ServiceBus'.
     */
    @JvmName("lmaxxiirchcjvvgw")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The URL of the ServiceBus namespace for identity-based authentication. It must include the protocol 'sb://'.
     */
    @JvmName("gvmehvlidpxjyhqs")
    public suspend fun endpointUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointUri = mapped
    }

    /**
     * @param value The ServiceBus Topic name for identity-based authentication.
     */
    @JvmName("xvivtwueufwbwmex")
    public suspend fun entityPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityPath = mapped
    }

    /**
     * @param value Managed identity properties for the endpoint.
     */
    @JvmName("xafjeaynhfeaetpy")
    public suspend fun identity(`value`: ManagedIdentityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity properties for the endpoint.
     */
    @JvmName("kwlsvteopesgjrsc")
    public suspend fun identity(argument: suspend ManagedIdentityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("kteoeajhqddhhyii")
    public suspend fun primaryConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryConnectionString = mapped
    }

    /**
     * @param value SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
     */
    @JvmName("xwbqhuoiemrmddod")
    public suspend fun secondaryConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryConnectionString = mapped
    }

    internal fun build(): ServiceBusArgs = ServiceBusArgs(
        authenticationType = authenticationType,
        deadLetterSecret = deadLetterSecret,
        deadLetterUri = deadLetterUri,
        endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
        endpointUri = endpointUri,
        entityPath = entityPath,
        identity = identity,
        primaryConnectionString = primaryConnectionString,
        secondaryConnectionString = secondaryConnectionString,
    )
}
